<?php 
$page_name = 'Add Category';

require_once('includes/connection.php');
require_once('includes/header.php');
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD CATEGORY
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="category_master.php">Category</a></li>
        <li class="active">Add Category</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">*All fields are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="categoryForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4 category-row">
                            <div class="form-group">
                                <label>Category Name</label>
                                <input class="form-control" type="text" autocomplete="off" id="category_name" name="category_name[]" required>
                            </div>
                        </div>
                        
                        <div class="col-md-2 d-flex align-items-end">
                         <button type="button" class="btn btn-primary btn-circle category-add-btn" id="addMoreButton"><i class="fas fa-plus"></i></button>
                       </div>
           
                    </div>
                              
                        <div id="additionalCategories"></div>
                
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <a href="category_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
    $(document).ready(function() {
        // Function to handle the "Add More" button click
        $('#addMoreButton').on('click', function () {
const newInputHTML = `
  <div class="row">
    <div class="col-md-4 category-row">
      <div class="form-group">
        <label>Category Name</label>
        <input class="form-control" type="text" autocomplete="off" name="category_name[]" required>
      </div>
    </div>
    <div class="col-md-2 d-flex align-items-end">
      <button type="button" class="btn btn-danger btn-circle removeButton category-add-btn"><i class="fas fa-minus"></i></button>
    </div>
  </div>
`;

            $('#additionalCategories').append(newInputHTML);
        });

        // Event delegation for removing input fields
        $('#additionalCategories').on('click', '.removeButton', function () {
            // Remove the parent div (col-md-4) of the clicked button
            $(this).closest('.row').remove();
        });

        // Handle form submission
        $('#categoryForm').on('submit', function(event) {
            event.preventDefault();

            const categoryNames = [];
            $('input[name="category_name[]"]').each(function() {
                categoryNames.push($(this).val());
            });

            $.ajax({
                url: 'apis/add_category_api.php',
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    category_name: categoryNames
                }),
                success: function(data) {
                    if (data.status === 'success') {
                        showAlert(data.message, 'success');
                        
                        $('input[name="category_name[]"]').val('');

                        $('#additionalCategories').empty();
                    } else {
                        showAlert(data.message, 'danger');
                    }
                },
                error: function(error) {
                    console.error('Error:', error);
                    showAlert('An error occurred while processing your request.', 'danger');
                }
            });
        });
    });
</script>

</body>
</html>