<?php 
$page_name = 'Add Course';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<style>
.card
{    
    border: 1px solid #5C2C8B;
    padding: 15px;
    border-radius: 5px;
    margin-top: 15px;
    
}

.card-header {
    padding: var(--bs-card-cap-padding-y) var(--bs-card-cap-padding-x);
    margin-bottom: 0;
    color: var(--bs-card-cap-color);
    background-color: #F8F8F8;
    border-bottom: #F8F8F8;
}

.box-header.with-border-section {
    border-bottom: 1px solid #0000002d;
    background: #F8F8F8;
    padding: 15px;
    border-radius: 5px;
}

.box-default-module
{
    border: 1px solid #0000002d;
    border-radius: 5px;
}

.box-default-submodule
{
    border: 1px solid #0000002d;
    border-radius: 5px;
}

.selected-file
{
    background-color: #eee;
    padding: 5px;
    box-shadow: none;
    border-radius: 5px;
    line-height: 22px;
    border: 1px solid #cccccc;
}

.skill-tag {
  display: inline-block;
  background-color: #f0e7ff;
  color: #5D2B8B;
  padding: 5px 10px;
  border-radius: 20px;
  margin: 5px 5px 0 8px;
  font-size: 14px;
  position: relative;
}

.skill-tag .remove-skill {
  margin-left: 8px;
  color: #999;
  cursor: pointer;
  font-weight: bold;
}

#skillsInput {
  border: none;
  outline: none;
  padding: 6px 12px;
  min-width: 150px;
}
.skill-input-wrapper {
  display: flex;
  flex-wrap: wrap;
  border: 1px solid #d2d6de;
  border-radius: 5px;
}

  .disabled-tab {
    pointer-events: none;
  }
  
  .selected-file a {
  display: inline-block;
  max-width: 100%;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  vertical-align: middle;
}

.select2-container {
  width: 100% !important;
}
</style>

<div id="uploadLoader"  style="display:none;">
  <div class="loader-overlay">
    <div class="loader-text">⏳ Your file is uploading, please wait...</div>
  </div>
</div>


<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">ADD COURSE</span>
    <ol class="breadcrumb">
      <button type="button" class="btn btn-block btn-success btn-flat">
        Course No : <?php echo isset($_GET['course']) ? intval(base64_decode($_GET['course'])) : 0; ?>
      </button>
    </ol>
  </section>

  <section class="content">
    <div class="box box-default">
        
            <div class="box-header with-border">
                <p class="box-title">* Fields marked with an asterisk are required.</p>
                <div class="col-md-4 response-msg" id="responseMessage">
                </div>
            </div>
            
      <div class="row">
        <div class="col-md-12">
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
              <li class="active"><a href="#tab_1" class="tab-link disabled-tab" data-toggle="tab">Course Details</a></li>
              <li><a href="#tab_2" class="tab-link disabled-tab" data-toggle="tab">Modules And Course materials</a></li>
              <li><a href="#tab_3" class="tab-link disabled-tab" data-toggle="tab">Submodules And Course materials</a></li>
              <li><a href="#tab_4" class="tab-link disabled-tab" data-toggle="tab">Quiz</a></li>
              <li><a href="#tab_5" class="tab-link disabled-tab" data-toggle="tab">Assignment</a></li>
            </ul>


            <div class="tab-content">
              <!-- TAB 1 -->
        <div class="tab-pane active" id="tab_1">
            <div class="box-body">

                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">Course Title <span class="text-danger">*</span></label>
                            <div class="col-md-9">
                                <input class="form-control" type="text" id="course_title" name="course_title" required>
                            </div>
                        </div>
                        
                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Description <span class="text-danger">*</span></label>
                        <div class="col-md-9">
                          <textarea class="form-control" id="course_description" name="course_description" rows="4"></textarea>
                        </div>
                      </div>
                      

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Category <span class="text-danger">*</span></label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="category" name="category" style="width: 100%;"></select>
                        </div>
                      </div>
                      
                      
                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Level</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="level" name="level" style="width: 100%;" tabindex="4">
                            <option value="">Select Level</option>
                            <option value="1">Easy</option>
                            <option value="2">Intermediate</option>
                            <option value="3">Hard</option>
                          </select>
                        </div>
                      </div>
                      

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Language</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="language" name="language" style="width: 100%;" tabindex="4">
                            <option value="">Select Language</option>
                            <option value="english">English</option>
                            <option value="marathi">Marathi</option>
                            <option value="hindi">Hindi</option>
                          </select>
                        </div>
                      </div>
                      
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">No. Of Licenses <span class="text-danger">*</span></label>
                            <div class="col-md-9">
                                <input class="form-control" type="number" id="licenses" name="licenses" required>
                            </div>
                        </div> 
                        
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">Course Hours</label>
                            <div class="col-md-9">
                                <input class="form-control" type="number" id="hours" name="hours" required>
                            </div>
                        </div>                         
                      
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">Course Fees</label>
                            <div class="col-md-9">
                                <input class="form-control" type="number" id="course_fees" name="course_fees" required>
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">Course Date <span class="text-danger">*</span></label>
                            <div class="col-md-4">
                                <input class="form-control" type="date" id="start_date" name="start_date" required>
                            </div>
                            <div class="col-md-4">
                                <input class="form-control" type="date" id="end_date" name="end_date" required>
                            </div>                            
                        </div>                  
                        

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Mentor</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="mentor" name="mentor" style="width: 100%;" data-placeholder="Select Mentors" multiple></select>
                        </div>
                      </div>
                      
                      
                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Industry Expert</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="industry_expert" style="width: 100%;" data-placeholder="Select Industry Expert" multiple></select>
                        </div>
                      </div>                      
                      
                      
                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Testimonials</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="testimonials" name="testimonials" style="width: 100%;" data-placeholder="Select Testimonials" multiple></select>
                        </div>
                      </div>
                      
                      
                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Proposed Courses</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="proposed_courses" name="proposed_courses" style="width: 100%;" data-placeholder="Select Proposed Courses" multiple></select>
                        </div>
                      </div> 
                      

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">FAQs</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="faqs" name="faqs" style="width: 100%;" data-placeholder="Select FAQs" multiple></select>
                        </div>
                      </div>                       
                        
                        
                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Skills</label>
                        <div class="col-md-9">
                          
                            <div class="skill-input-wrapper" id="skillsWrapper">
                              <input type="text" class="form-control" id="skillsInput" />
                            </div>
                            
                            <input type="hidden" name="skills" id="skillsHiddenInput" />
                        </div>
                      </div>
                      
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">What you'll Learn</label>
                        <div class="col-md-9">
                            <textarea id="learnings" class="form-control" rows="5"></textarea>
                        <small class="text-muted">Enter each point on a new line</small>
                        </div>
                    </div>  

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Image</label>
                        <div class="col-md-9">
                          <input class="form-control" type="file" id="course_image" name="course_image"  accept="image/png, image/jpeg">
                                <div id="currentInstituteImage" style="margin-top:10px;">
                                <img id="courseImagePreview" src="" alt="Course Image" style="max-height: 100px; border: 1px solid rgb(221, 221, 221); padding: 5px;">
                                </div>        
                                
                        <small class="text-muted">Image Size - 590  X 390</small>
                        </div>
                      </div>   
                      
                  
                  <div class="box-footer text-center mt-4">
                      <button type="button" class="btn btn-secondary" onclick="window.location.href='course_master.php'">Cancel</button>
                      <button type="button" id="goToTab2" class="btn btn-primary">Save And Next &gt;&gt;</button>
                    </div>
                    
            </div>
        </div>

              <!-- TAB 2: MODULES -->
              <div class="tab-pane" id="tab_2">
      
  <!-- Button to open modal -->
<button class="btn btn-primary mb-15 mt-25" data-toggle="modal" data-target="#existingModulesModal">
  Select Existing Modules
</button>

  <!-- Table of selected/created modules -->
  <h5>Existing Modules</h5>
  <table class="table table-bordered" id="moduleTable">
    <thead>
      <tr>
         <th><i class="fa fa-arrows"></i></th> 
        <th>Sr No.</th>
        <th>Module Name</th>
        <th>No. Of Files</th>
      </tr>
    </thead>
    <tbody id="moduleTableBody">
      <!-- Filled dynamically -->
    </tbody>
  </table>

  <!-- Button to create new module -->
  <button class="btn btn-primary mb-10" onclick="addNewModule()">+ Create New Module</button>
  <hr>

  <!-- Container for new modules -->
  <div id="newModulesContainer"></div>

  <!-- Modal for existing modules -->
  <div class="modal fade" id="existingModulesModal" tabindex="-1" aria-labelledby="existingModulesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" style="float: left;">Select Existing Modules</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
  <span aria-hidden="true">&times;</span>
</button>
        </div>
        <div class="modal-body" style="height: 500px;overflow-y: scroll;">
            
 <input type="text" id="moduleSearch" class="form-control mb-3" placeholder="Search modules...">
 <br>
 
          <ul class="list-group" id="existingModulesList">
            <!-- Populated dynamically -->
          </ul>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary" onclick="addSelectedModules()" data-bs-dismiss="modal">Add Selected Modules</button>
        </div>
      </div>
    </div>
  </div>
  
  <div class="box-footer text-center mt-4">
  <button type="button" id="backToTab1" class="btn btn-secondary">&lt;&lt; Back</button>
  <button type="button" id="goToTab3" class="btn btn-primary">Save And Next &gt;&gt;</button>
</div>

              </div>


              <!-- TAB 3 -->
<div class="tab-pane" id="tab_3">
  <!-- Button to open modal -->
  <button class="btn btn-primary mb-15 mt-25" data-toggle="modal" data-target="#existingSubModulesModal">
    Select Existing Submodules
  </button>


<h5>Existing Submodules</h5>
<table class="table table-bordered" id="subModuleTable">
  <thead>
    <tr>
      <th><i class="fa fa-arrows"></i></th> 
      <th>Sr No.</th>
      <th>Submodule Name</th>
      <th>Module Name</th>
      <th>No. Of Files</th>
    </tr>
  </thead>
  <div>
  <tbody id="submoduleTableBody">

  </tbody>
  </div>
</table>


  <!-- Button to create new submodule -->
  <button class="btn btn-primary mb-10" onclick="addNewSubmodule()">+ Create New Submodule</button>
  <hr>

  <!-- Container for new submodules -->
  <div id="newSubmodulesContainer"></div>

  <!-- Modal for existing submodules -->
  <div class="modal fade" id="existingSubModulesModal" tabindex="-1" aria-labelledby="existingSubModulesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Select Existing Submodules</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" style="height: 500px;overflow-y: scroll;">
          <ul class="list-group" id="existingSubmodulesList">
            <!-- Populated dynamically -->
          </ul>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary" onclick="addSelectedSubmodules()" data-bs-dismiss="modal">Add Selected Submodules</button>
        </div>
      </div>
    </div>
  </div>
  
  <div class="box-footer text-center mt-4">
  <button type="button" id="backToTab2" class="btn btn-secondary">&lt;&lt; Back</button>
  <button type="button" id="goToTab4" class="btn btn-primary">Save And Next &gt;&gt;</button>
</div>


</div>


              <!-- TAB 4 -->
              <div class="tab-pane" id="tab_4">
                <div id="loader" style="display:none;">Loading...</div>

        <div class="box-body table-padding">
          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th>Quiz</th>
                <th>Module</th>
                <th>Action</th>
              </tr>
            </thead>
          </table>
        </div>
        
        <div class="box-footer text-center mt-4">
  <button type="button" id="backToTab3" class="btn btn-secondary">&lt;&lt; Back</button>
  <button type="button" id="goToTab5" class="btn btn-primary">Save And Next &gt;&gt;</button>

</div>

        
              </div>
              
              
              <!-- TAB 5 -->
<div class="tab-pane" id="tab_5">
  <div id="loader" style="display:none;">Loading...</div>

  <div class="box-body table-padding">
    <div class="row mb-3">
      <div class="col-md-4">
        <select id="assignmentDropdown" class="form-control select2">
          <option value="">Select Assignment</option>
        </select>
      </div>
      <div class="col-md-2">
        <button id="assignBtn" class="btn btn-primary">Assign</button>
      </div>
    </div>
  </div>

  <div class="box-footer text-center mt-4">
    <button type="button" id="backToTab4" class="btn btn-secondary">&lt;&lt; Back</button>
    <button type="button" id="finishCourse" class="btn btn-primary">Finish</button>
  </div>
</div>
            

            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php require_once('includes/footer.php'); ?>

<!-- jQuery UI -->
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css" />



<!--for course-->

<script>

populateCategories('category');

populateMentors('mentor');

populateIndustryExpert('industry_expert');

populateTestimonials('testimonials');

populateProposedCourses('proposed_courses');

populateFaqs('faqs');

const course_id = atob('<?php echo $_GET["course"]; ?>');
//const course_id = atob('<?php echo isset($_GET['course']) ? intval($_GET['course']) : 0 ?>');


function loadExistingModules() {
  $.ajax({
    url: './cr/get_modules_api.php',
    type: 'POST',
    data: { course_id: course_id },
    dataType: 'json',
    success: function (data) {
      const list = $('#existingModulesList');
      list.empty();

      if (!data || typeof data !== 'object') {
        list.append('<li class="list-group-item text-danger">Invalid response from server.</li>');
        return;
      }

      if (data.status === 'success' && Array.isArray(data.data)) {
        const addedModuleIds = new Set();
        $('#newModulesContainer .card').each(function () {
          const id = $(this).attr('id');
          const match = id && id.match(/^module_(\d+)$/);
          if (match) addedModuleIds.add(match[1]);
        });

        data.data.forEach(function (mod) {
          const isChecked = mod.is_selected == 1 ? 'checked' : '';
          const li = `
            <li class="list-group-item">
              <div class="form-check d-flex align-items-center" style="gap: 10px;">
                <input type="checkbox" class="form-check-input" value="${mod.module_id}" data-module-name="${mod.module_name}" ${isChecked} />
                <label class="form-check-label mb-0" style="cursor: pointer;position: unset;">
                  ${mod.module_name}
                </label>
              </div>
            </li>`;
          list.append(li);
        });
      } else {
        // Show PHP message if available
        const msg = data.message || 'Failed to load modules.';
        list.append(`<li class="list-group-item text-danger">${msg}</li>`);
      }
    },
    error: function (xhr, status, error) {
      $('#existingModulesList').html(`<li class="list-group-item text-danger">AJAX error: ${error}</li>`);
    }
  });
}


function refreshModulesUI(courseId) {
  $.ajax({
    url: './cr/get_initial_data.php',
    method: 'GET',
    data: { course_id: courseId },
    dataType: 'json',
    success: function (res) {
      if (res.status === 'success') {
        $('#moduleTableBody').empty();
        $('#newModulesContainer').empty();
        renderModuleCards(res.data);
        renderModuleTable(res.data);
        
        currentModuleIds = res.data.map(mod => mod.module_id);
        
      }
    }
  });
}

window.onload = function () {
  refreshModulesUI(course_id);

  $('#existingModulesModal').on('shown.bs.modal', function () {
    loadExistingModules();
  });

  let moduleCounter = 1;

  window.addNewModule = function () {
    const moduleId = `newModule${moduleCounter++}`;
    const container = document.getElementById('newModulesContainer');

    const card = document.createElement('div');
    card.className = 'box box-default-module';
    card.id = moduleId;
    card.innerHTML = `
      <div class="box-body">
        <div class="row mb-2 mt-25" style="margin-bottom: 25px;">

        <div class="col-md-6">
            <input type="text" id="${moduleId}-title" class="form-control me-2" placeholder="Enter Module Name" />
        </div>
 
 
        <div class="col-md-6">
            <button class="btn btn-primary" onclick="submitStudies('${moduleId}', 0)">Add Module</button>

        <a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="document.getElementById('${moduleId}').remove();" title="Remove Module"><i class="fa fa-minus"></i></a>
        
                          
        </div>
    
        </div>
        
        <div class="study-rows" id="${moduleId}-study-rows"></div>
        
      </div>
    `;
    container.appendChild(card);
    card.scrollIntoView({ behavior: "smooth", block: "start" });
  };

  window.submitStudies = function (moduleDomId, moduleDbId) {
    const titleInput = document.getElementById(`${moduleDomId}-title`);
    const title = titleInput.value.trim();

    if (!title) {
      alert("Please enter a module name.");
      return;
    }

    $.ajax({
      type: "POST",
      url: "./cr/add_module_and_assign_api.php",
      data: { module_name: title, course_id: course_id},
      dataType: "json",
      success: function (res) {
        if (res.status === "success") {
    const card = document.getElementById(moduleDomId);
    card.setAttribute("data-module-db-id", res.module_id);        
          refreshModulesUI(course_id);
        } else {
          alert(res.message || "Failed to add module.");
        }
      },
      error: function () {
        alert("AJAX error occurred.");
      }
    });
  };

  window.addStudyRow = function (moduleId) {
    const container = document.getElementById(`${moduleId}-study-rows`);
    if (!container) {
      console.error(`Missing study row container for moduleId: ${moduleId}`);
      return;
    }
    const row = document.createElement("div");
    row.className = "study-row row mb-2 mt-25";
    row.innerHTML = `
      <div class="col-md-6">
        <input type="text" class="form-control study-title" placeholder="Study Title" />
      </div>
      
      <div class="col-md-4">
        <input type="file" class="form-control study-file" accept=".pdf,.ppt,.pptx,.png,.jpg,.jpeg,.mp4"  />
      </div>
      <div class="col-md-1">
        <button class="btn btn-sm" style="background: #5D2B8B;color:#fff;" onclick="uploadSingleStudy(this, '${moduleId}')">Upload</button>
      </div>
      <div class="col-md-1">
      <a href="javascript:void(0);" onclick="this.closest('.study-row').remove()">
        <img src="images/delete.svg" title="Delete Study Material">
      </a>
      </div>
    `;
    container.appendChild(row);
  };

window.uploadSingleStudy = function (btn, moduleDomId) {
  const row = btn.closest('.study-row');
  const titleInput = row.querySelector(".study-title");
  const fileInput = row.querySelector(".study-file");

  const title = titleInput.value.trim();
  const file = fileInput.files[0];
  const allowedExtensions = ['pdf', 'ppt', 'pptx', 'png', 'jpg', 'jpeg', 'mp4', 'txt'];

  if (!title || !file) {
    alert("Please provide both title and file.");
    return;
  }
  
    if (file) {
      const fileExt = file.name.split('.').pop().toLowerCase();
      if (!allowedExtensions.includes(fileExt)) {
        alert("Invalid file type! Please upload only PDF, PPT, TXT, PNG, JPG, JPEG, or MP4 files.");
        fileInput.value = "";
        return;
      }
      
        if (file && file.size > 100 * 1024 * 1024) {
          alert("File size must be less than 100MB.");
          fileInput.value = "";
          return;
        } 
        
    } 

  const moduleDbId = getModuleDbIdFromDomId(moduleDomId);
  if (!moduleDbId) {
    alert("Module ID not found. Please save the module first.");
    return;
  }

  const formData = new FormData();
  formData.append("action", "upload_single_study");
  formData.append("module_id", moduleDbId);
  formData.append("title", title);
  formData.append("file", file);
  formData.append("category_id", $('#category').val());

  // Show loader overlay
  $('#uploadLoader').show();

  $.ajax({
    url: "./cr/upload_file.php",
    method: "POST",
    data: formData,
    processData: false,
    contentType: false,
    success: function (res) {
      // Hide loader when done
      $('#uploadLoader').hide();

      if (res.status === "success") {
        if (res.video_id) {
          row.setAttribute("data-video-id", res.video_id);
        }
        refreshModulesUI(course_id);
      } else {
        showAlert('An error occurred while uploading your content. Please try again.', 'danger');  
      }
    },
    error: function () {
      $('#uploadLoader').hide();
      showAlert('An error occurred while uploading your content. Please try again.', 'danger');      
    },
  });
};


function getModuleDbIdFromDomId(moduleDomId) {
  const card = document.getElementById(moduleDomId);
  if (!card) return null;

  const moduleDbId = card.getAttribute("data-module-db-id");
  return moduleDbId ? parseInt(moduleDbId) : null;
}


  window.addSelectedModules = function () {
    const selected = $('#existingModulesList input:checked');
    if (selected.length === 0) {
      alert('Please select at least one module.');
      return;
    }

    const moduleIds = [];
    const moduleNames = {};

    selected.each(function () {
      const moduleId = $(this).val();
      const moduleName = $(this).data('module-name');
      moduleIds.push(moduleId);
      moduleNames[moduleId] = moduleName;
    });

    $.ajax({
      url: './cr/add_course_module_api.php',
      type: 'POST',
      data: JSON.stringify({ module_ids: moduleIds, course_id: course_id }),
      contentType: 'application/json',
      success: function (response) {
        if (response.status === 'success') {
          refreshModulesUI(course_id);
          $('#existingModulesModal').modal('hide');
          alert(response.message);
        } else {
          alert(response.message || 'Something went wrong!');
        }
      },
      error: function (xhr) {
        console.error(xhr.responseText);
        alert('Error contacting API.');
      }
    });
  };

  window.deleteVideoFromVimeo = function (btn) {
    const row = btn.closest('.study-row');
    const videoId = row.getAttribute('data-video-id');

    if (!videoId) {
      row.remove();
      return;
    }

    if (!confirm("Are you sure you want to delete this study material??")) return;

    $.ajax({
      url: './cr/delete_vimeo_video.php',
      type: 'POST',
      data: { video_id: videoId },
      dataType: 'json',
      success: function (response) {
        if (response.success) {
          row.remove();
          alert('Content deleted successfully.');
        } else {
          alert('Failed to delete video: ' + response.message);
        }
      },
      error: function (xhr, status, error) {
        alert('AJAX error: ' + error);
      }
    });
  };
};


function renderModuleTable(modules) {
  $('#moduleTableBody').empty();
  modules.forEach((module, index) => {
    const studyCount = module.study_materials ? module.study_materials.length : 0;
    const row = `
      <tr data-module-id="${module.module_id}">
        <td class="drag-handle" style="cursor: move;"><i class="fa fa-arrows"></i></td>
        <td>${index + 1}</td>
        <td>${module.module_name}</td>
        <td>${studyCount}</td>
      </tr>`;
    $('#moduleTableBody').append(row);
  });
}

function renderModuleCards(modules) {
  modules.forEach(module => {
    const moduleId = module.module_id;
    const moduleName = module.module_name;
    const studyMaterials = module.study_materials || [];
    const uniqueId = 'card_' + moduleId + '_' + Date.now();
    const folder_name = module.folder_name;

    let studyRowsHTML = `
      <div class="box box-default-module" id="${uniqueId}" data-module-db-id="${moduleId}">
        <div class="box-header with-border-section">
          <h3 class="box-title-course">Module Name - ${moduleName}</h3>
          <div class="box-tools pull-right">
            <button class="btn btn-sm btn-danger remove-module-btn" data-module-id="${moduleId}" style="margin-top: 3px;" data-card-id="${uniqueId}">Remove</button>
          </div>
        </div>
        <div class="box-body">
          <div class="study-rows" id="${uniqueId}-study-rows">
    `;

    studyMaterials.forEach(material => {
      const title = material.title || '';
      const fileName = material.original_file_name || '';
      const actualFileName = material.actual_file_name || '';
      const vimeoLink = material.vimeo_link || '';
      const materialId = material.study_material_id;

      // Determine if it's a file (not a video)
      const isFile = !vimeoLink && fileName;
      const fileLink = isFile 
        ? `./institutes/${folder_name}/study_materials/${actualFileName}` 
        : vimeoLink;

      studyRowsHTML += `
        <div class="study-row row mb-2 mt-25" data-video-id="${materialId}">
          <div class="col-md-6">
            <a href="edit_module.php?id=${btoa(moduleId)}" target="_blank">
            <input type="text" class="form-control study-title" value="${title}" style="cursor:pointer;" readonly>
            </a>
          </div>
          <div class="col-md-4 selected-file">
            <a href="${fileLink}" target="_blank">${fileName}</a>
          </div>
          <div class="col-md-1">
            <button class="btn btn-sm" style="background: #5D2B8B;color:#fff;" onclick="uploadSingleStudy(this, '${uniqueId}')">Upload</button>
          </div>
          <div class="col-md-1">
            <a href="javascript:void(0);" onclick="deleteVideoFromVimeo(this)">
              <img src="images/delete.svg" title="Delete Study Material" />
            </a>
          </div>
        </div>
      `;
    });

    studyRowsHTML += `
          </div>
          <div class="row mt-2 mt-25">
            <div class="col-md-7">
              <button class="btn btn-secondary btn-sm mb-2" onclick="addStudyRow('${uniqueId}')">+ Add Study</button>
            </div>
          </div>
        </div>
      </div>
    `;

    $('#newModulesContainer').append(studyRowsHTML);
  });
}


$(document).on('click', '.remove-module-btn', function () {
  const moduleId = $(this).data('module-id');
  const cardId = $(this).data('card-id');

  if (!confirm("Are you sure you want to delete this module?")) return;

  $.ajax({
    url: './cr/delete_course_module_api.php',
    method: 'POST',
    data: { module_id: moduleId, course_id: course_id },
    dataType: 'json',
    success: function (response) {
      if (response.status === 'success') {
        document.getElementById(cardId)?.remove();
        loadExistingModules();
        refreshModulesUI(course_id);
        alert('Module removed successfully.');
      }
    },
    error: function () {
      alert('AJAX error occurred while deleting.');
    }
  });
});


$("#moduleTableBody").sortable({
  handle: '.drag-handle',
  update: function (event, ui) {
    const updatedOrder = [];
    $("#moduleTableBody tr").each(function (index) {
      const moduleId = $(this).data("module-id");
      if (moduleId) {
        updatedOrder.push({
          module_id: moduleId,
          sequence: index + 1
        });
      }
    });

    // Send new order to backend
    $.ajax({
      url: './cr/update_module_sequence.php',
      type: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({ course_id: course_id, modules: updatedOrder }),
      success: function (response) {
        if (response.status === 'success') {
          console.log('Sequence updated successfully');
        } else {
          console.warn('Failed to update sequence');
        }
      },
      error: function () {
        console.error('Error updating sequence');
      }
    });
  }
});

$("#submoduleTableBody").sortable({
  handle: '.drag-handle',
  update: function (event, ui) {
    const updatedOrder = [];

    // refresh Sr No after drag
    $("#submoduleTableBody tr").each(function (index) {
      const submoduleId = $(this).data("submodule-id");
      const moduleId = $(this).data("module-id");
      if (submoduleId) {
        updatedOrder.push({
          submodule_id: submoduleId,
          module_id: moduleId,
          sequence: index + 1
        });
      }
    });
    // Send new order to backend
    $.ajax({
      url: './cr/update_submodule_sequence.php',
      type: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({ course_id: course_id, submodules: updatedOrder }),
      success: function (response) {
        if (response.status === 'success') {
          console.log('Sequence updated successfully');
        } else {
          console.warn('Failed to update sequence');
        }
      },
      error: function () {
        console.error('Error updating sequence');
      }
    });
  }
});













//Submodules

let submoduleCounter = 1;
refreshSubmodulesUI(course_id);
    
    
function loadExistingSubmodules() {
    
  if (currentModuleIds.length === 0) {
    $('#existingSubmodulesList').html('<li class="list-group-item text-warning">Please add at least one module before selecting submodules.</li>');
    return;
  }
  
  $.ajax({
    url: './cr/get_submodules_api.php',
    type: 'POST',
    data: { course_id: course_id, module_ids: currentModuleIds.join(',') },
    dataType: 'json',
    success: function (data) {
      const list = $('#existingSubmodulesList');
      list.empty();

      if (!data || typeof data !== 'object') {
        list.append('<li class="list-group-item text-danger">Invalid response from server.</li>');
        return;
      }

      if (data.status === 'success' && Array.isArray(data.data)) {
        // Populate the list
        data.data.forEach(function (sub) {
          const isChecked = sub.is_selected == 1 ? 'checked' : '';
          const li = `
            <li class="list-group-item">
              <div class="form-check d-flex align-items-center" style="gap: 10px;">
                <input type="checkbox" class="form-check-input" value="${sub.submodule_id}" data-module-id-sub="${sub.module_id}"  data-submodule-name="${sub.submodule_name}" ${isChecked} />
                <label class="form-check-label mb-0" style="cursor: pointer; position: unset;">
                  ${sub.submodule_name}
                </label>
              </div>
            </li>`;
          list.append(li);
        });
      } else {
        // Show the message from PHP if available
        const msg = data.message || 'Failed to load submodules.';
        list.append(`<li class="list-group-item text-danger">${msg}</li>`);
      }
    },
    error: function (xhr, status, error) {
      $('#existingSubmodulesList').html(`<li class="list-group-item text-danger">AJAX error: ${error}</li>`);
    }
  });
}


function refreshSubmodulesUI(courseId) {
  $.ajax({
    url: './cr/get_initial_submodules.php',
    method: 'GET',
    data: { course_id: courseId },
    dataType: 'json',
    success: function (res) {
      if (res.status === 'success') {
        $('#submoduleTableBody').empty();
        $('#newSubmodulesContainer').empty();
        renderSubmoduleCards(res.data);
        renderSubmoduleTable(res.data);
      }
    }
  });
}


function addNewSubmodule() {
  const submoduleId = `newSubmodule${submoduleCounter++}`;
  const moduleSelectId = `${submoduleId}-category`;
  const container = document.getElementById('newSubmodulesContainer');

  const card = document.createElement('div');
  card.className = 'box box-default-submodule';
  card.id = submoduleId;
  card.innerHTML = `
    <div class="box-body">
      <div class="row mb-2 mt-25" style="margin-bottom: 25px;">
            <div class="col-md-3">
                <select class="form-control select2 category-select" id="${moduleSelectId}" name="module_id" style="width: 100%;"></select>
            </div>      
        <div class="col-md-4">
          <input type="text" id="${submoduleId}-title" class="form-control me-2" placeholder="Enter Submodule Name" />
        </div>
        <div class="col-md-5">
          <button class="btn btn-primary" onclick="submitSubStudies('${submoduleId}', 0,  '${moduleSelectId}')">Add Submodule</button>
          <a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="document.getElementById('${submoduleId}').remove();" title="Remove Submodule"><i class="fa fa-minus"></i></a>
        </div>
      </div>
      <div class="study-rows" id="${submoduleId}-study-rows"></div>
    </div>
  `;
  container.appendChild(card);
  populateCoursesModules(moduleSelectId, course_id);
  card.scrollIntoView({ behavior: "smooth", block: "start" });
  
    $(`#${moduleSelectId}`).select2({
    placeholder: "Select Module",
    width: 'resolve'
  });
  
}

function submitSubStudies(submoduleDomId, submoduleDbId, moduleDbId) {
  const titleInput = document.getElementById(`${submoduleDomId}-title`);
  const title = titleInput.value.trim();
  const moduleSelect = document.getElementById(moduleDbId);
  const moduleId = moduleSelect.value;

  if (!title || !moduleId) {
    alert("Please enter submodule name and select a valid module.");
    return;
  }

  $.ajax({
    type: "POST",
    url: "./cr/add_submodule_and_assign_api.php",
    data: { submodule_name: title, course_id: course_id, module_id: moduleId},
    dataType: "json",
    success: function (res) {
      if (res.status === "success") {
        const card = document.getElementById(submoduleDomId);
        card.setAttribute("data-submodule-db-id", res.submodule_id);
        card.setAttribute("data-module-id", moduleId);
        refreshSubmodulesUI(course_id);
      } else {
        alert(res.message || "Failed to add submodule.");
      }
    },
    error: function () {
      alert("AJAX error occurred.");
    }
  });
}


  window.addStudyRowSub = function (submoduleId) {
    const container = document.getElementById(`${submoduleId}-study-rows`);
    if (!container) {
      console.error(`Missing study row container for submoduleId: ${submoduleId}`);
      return;
    }
    const row = document.createElement("div");
    row.className = "study-rowsub row mb-2 mt-25";
    row.innerHTML = `
      <div class="col-md-6">
        <input type="text" class="form-control study-title" placeholder="Study Title" />
      </div>
      <div class="col-md-4">
        <input type="file" class="form-control study-file" accept=".pdf,.ppt,.pptx,.png,.jpg,.jpeg,.mp4"  />
      </div>
      <div class="col-md-1">
        <button class="btn btn-sm" style="background: #5D2B8B;color:#fff;" onclick="uploadSingleStudySub(this, '${submoduleId}')">Upload</button>
      </div>
      <div class="col-md-1">
      <a href="javascript:void(0);" onclick="this.closest('.study-rowsub').remove()">
        <img src="images/delete.svg" title="Delete Study Material">
      </a>
      </div>
    `;
    container.appendChild(row);
  };

  window.uploadSingleStudySub = function (btn, submoduleDomId) {
    const row = btn.closest('.study-rowsub');
    const titleInput = row.querySelector(".study-title");
    const fileInput = row.querySelector(".study-file");

    const title = titleInput.value.trim();
    const file = fileInput.files[0];
    const allowedExtensions = ['pdf', 'ppt', 'pptx', 'png', 'jpg', 'jpeg', 'mp4', 'txt'];
    
    if (!title || !file) {
      alert("Please provide both title and file.");
      return;
    }
    
    
    if (file) {
      const fileExt = file.name.split('.').pop().toLowerCase();
      if (!allowedExtensions.includes(fileExt)) {
        alert("Invalid file type! Please upload only PDF, PPT, TXT, PNG, JPG, JPEG, or MP4 files.");
        fileInput.value = "";
        return;
      }
      
        if (file && file.size > 100 * 1024 * 1024) {
          alert("File size must be less than 100MB.");
          fileInput.value = "";
          return;
        } 
        
    }
    

    const submoduleDbId = getSubmoduleDbIdFromDomId(submoduleDomId);
    if (!submoduleDbId) {
      alert("Submodule ID not found. Please save the submodule first.");
      return;
    }
    
  const submoduleBlock = document.getElementById(submoduleDomId);
  const moduleDbId = submoduleBlock?.getAttribute("data-module-id");
  if (!moduleDbId) {
    alert("Module ID not found for this submodule.");
    return;
  }    

    const formData = new FormData();
    formData.append("action", "upload_single_study_sub");
    formData.append("submodule_id", submoduleDbId);
    formData.append("module_id", moduleDbId);
    formData.append("title", title);
    formData.append("file", file);
    formData.append("category_id", $('#category').val());

  // Show loader overlay
  $('#uploadLoader').show();
  
    $.ajax({
      url: "./cr/upload_file_sub.php",
      method: "POST",
      data: formData,
      processData: false,
      contentType: false,
      success: function (res) {
           $('#uploadLoader').hide();
        if (res.status === "success") {
          
          if (res.video_id) {
            row.setAttribute("data-video-id", res.video_id);
          }
          
           refreshSubmodulesUI(course_id);
        } else {
          showAlert('An error occurred while uploading your content. Please try again.', 'danger');
        }
      },
      error: function () {
        showAlert('An error occurred while uploading your content. Please try again.', 'danger');
      },
    });
  };

function getSubmoduleDbIdFromDomId(submoduleDomId) {
  const card = document.getElementById(submoduleDomId);
  if (!card) return null;

  const submoduleDbId = card.getAttribute("data-submodule-db-id");
  return submoduleDbId ? parseInt(submoduleDbId) : null;
}


window.addSelectedSubmodules = function () {
  const selected = $('#existingSubmodulesList input:checked');
  if (selected.length === 0) {
    alert('Please select at least one submodule.');
    return;
  }

  const submoduleIds = [];
  const submoduleNames = {};
  let moduleId = null;

  selected.each(function (index) {
    const submoduleId = $(this).val();
    const submoduleName = $(this).data('submodule-name');
    const moduleIdSub = $(this).data('module-id-sub');

    submoduleIds.push(submoduleId);
    submoduleNames[submoduleId] = submoduleName;

    // Take moduleId from the first selected submodule
    if (index === 0) {
      moduleId = moduleIdSub;
    }
  });

  $.ajax({
    url: './cr/add_course_submodule_api.php',
    type: 'POST',
    data: JSON.stringify({ 
      submodule_ids: submoduleIds, 
      course_id: course_id, 
      module_id: moduleId
    }),
    contentType: 'application/json',
    success: function (response) {
      if (response.status === 'success') {
        refreshSubmodulesUI(course_id);
        $('#existingSubModulesModal').modal('hide');
        alert(response.message);
      } else {
        alert(response.message || 'Something went wrong!');
      }
    },
    error: function (xhr) {
      console.error(xhr.responseText);
      alert('Error contacting API.');
    }
  });
};



  window.deleteVideoFromVimeoSub = function (btn) {
    const row = btn.closest('.study-row');
    const videoId = row.getAttribute('data-video-id');

    if (!videoId) {
      row.remove();
      return;
    }

    if (!confirm("Are you sure you want to delete this study material ?")) return;

    $.ajax({
      url: './cr/delete_vimeo_video_sub.php',
      type: 'POST',
      data: { video_id: videoId },
      dataType: 'json',
      success: function (response) {
        if (response.success) {
          row.remove();
          alert('Content deleted successfully.');
        } else {
          alert('Failed to delete video: ' + response.message);
        }
      },
      error: function (xhr, status, error) {
        alert('AJAX error: ' + error);
      }
    });
  };


function renderSubmoduleTable(submodules) {
  $('#submoduleTableBody').empty(); // clear before rendering

  submodules.forEach((sub, index) => {
    const studyCount = sub.study_materials ? sub.study_materials.length : 0;
    const row = `
      <tr data-submodule-id="${sub.submodule_id}" data-module-id="${sub.module_id}">
        <td class="drag-handle" style="cursor: move;"><i class="fa fa-arrows"></i></td>      
        <td>${index + 1}</td>
        <td>${sub.submodule_name}</td>
        <td>${sub.module_name}</td>        
        <td>${studyCount}</td>
      </tr>`;
    $('#submoduleTableBody').append(row);
  });
}


function renderSubmoduleCards(submodules) {
  submodules.forEach(sub => {
    const submoduleId = sub.submodule_id;
    const submoduleName = sub.submodule_name;
    const moduleName = sub.module_name;
    const studyMaterials = sub.study_materials || [];
    const uniqueId = 'card_sub_' + submoduleId + '_' + Date.now();
    const folder_name = sub.folder_name;

    let studyRowsHTML = `
      <div class="box box-default-submodule" id="${uniqueId}" data-submodule-db-id="${submoduleId}" data-module-id="${sub.module_id}">
        <div class="box-header with-border-section">
          <h3 class="box-title-course">Submodule Name - ${submoduleName}   &nbsp;&nbsp;&nbsp;(Module - ${moduleName})</h3>
          <div class="box-tools pull-right">
            <button class="btn btn-sm btn-danger remove-submodule-btn" data-submodule-id="${submoduleId}" data-card-id="${uniqueId}">Remove</button>
          </div>
        </div>
        <div class="box-body">
        <div class="study-rows" id="${uniqueId}-study-rows">
    `;

    studyMaterials.forEach(material => {
      const title = material.title || '';
      const fileName = material.original_file_name || '';
      const actualFileName = material.actual_file_name || '';
      const vimeoLink = material.vimeo_link || '';
      const materialId = material.study_material_id;

      // Determine if it's a file (not a video)
      const isFile = !vimeoLink && fileName;
      const fileLink = isFile 
        ? `./institutes/${folder_name}/study_materials/${actualFileName}` 
        : vimeoLink;
        
      studyRowsHTML += `
        <div class="study-row row mb-2 mt-25" data-video-id="${materialId}">
          <div class="col-md-6">
            <input type="text" class="form-control study-title" value="${title}" readonly>
          </div>
          <div class="col-md-4 selected-file">
            <a href="${fileLink}" target="_blank">${fileName}</a>
          </div>
          <div class="col-md-1">
            <button class="btn btn-sm" style="background: #5D2B8B;color:#fff;" onclick="uploadSingleStudySub(this, '${uniqueId}')">Upload</button>
          </div>
          <div class="col-md-1">
            <a href="javascript:void(0);" onclick="deleteVideoFromVimeoSub(this)">
              <img src="images/delete.svg" title="Delete Study Material" />
            </a>
          </div>
        </div>
      `;
    });

    studyRowsHTML += `
          </div>
          <div class="row mt-2 mt-25">
            <div class="col-md-7">
              <button class="btn btn-secondary btn-sm mb-2" onclick="addStudyRowSub('${uniqueId}')">+ Add Study</button>
            </div>
          </div>
        </div>
      </div>
    `;

    $('#newSubmodulesContainer').append(studyRowsHTML);
  });
}

$(document).on('click', '.remove-submodule-btn', function () {
  const submoduleId = $(this).data('submodule-id');
  const cardId = $(this).data('card-id');

  if (!confirm("Are you sure you want to delete this submodule?")) return;

  $.ajax({
    url: './cr/delete_course_submodule_api.php',
    method: 'POST',
    data: { submodule_id: submoduleId, course_id: course_id },
    dataType: 'json',
    success: function (response) {
      if (response.status === 'success') {
        document.getElementById(cardId)?.remove();
        loadExistingSubmodules();
        refreshSubmodulesUI(course_id);
        alert('Submodule removed successfully.');
      }
    },
    error: function () {
      alert('AJAX error occurred while deleting.');
    }
  });
});


$(document).ready(function () {
  $('#existingSubModulesModal').on('show.bs.modal', function () {
    loadExistingSubmodules();
  });
});











// ================= QUIZ ADD =================
let quizCachedModules = null;
let quizDataTable = null;
let isQuizTableInitialized = false;
let quizAssignedModules = [];

function populateQuizModules(selectorId, selectedId = null) {
  if (!quizCachedModules) return;

  let options = '<option value="">Select Module</option>';
  quizCachedModules.forEach(function(module) {
    const selectedAttr = selectedId == module.id ? 'selected' : '';
    const disabledAttr = (quizAssignedModules.includes(module.id) && module.id != selectedId) ? 'disabled' : '';
    options += `<option value="${module.id}" ${selectedAttr} ${disabledAttr}>${module.name}</option>`;
  });
  $(`#${selectorId}`).html(options).trigger('change');
}

function initQuizTable() {
  if (isQuizTableInitialized) return;

  quizDataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    language: { search: "Search:" },
    ajax: {
      url: 'cr/quiz_api.php',
      type: 'POST',
      data: function (d) { d.course_id = course_id; },
      beforeSend: function () { $('#page-loader').show(); },
      complete: function () { $('#page-loader').hide(); },
      error: function(xhr, status, error) {
        console.error('Error loading quiz_api.php:', error);
      }
    },
    columns: [
      { data: 'quiz_title' },
      {
        data: null,
        render: function (data, type, row, meta) {
          const moduleId = `quiz_module_${meta.row}`;
          return `<select class="form-control quiz-module-dropdown" id="${moduleId}" data-row="${meta.row}"></select>`;
        }
      },
      {
        data: null,
        render: function (data, type, row, meta) {
          return `<button type="button" class="btn btn-sm btn-primary quiz-assign-btn" data-id="${row.quiz_id}">Assign</button>`;
        }
      }
    ],
    initComplete: function () {
      $('#dataGrid_filter input[type=search]').addClass('responsive-input');
      isQuizTableInitialized = true;
    }
  });

  $('#dataGrid').off('xhr.dt').on('xhr.dt', function (e, settings, json) {
    quizAssignedModules = json.assignedModules || [];
  });

  $('#dataGrid').off('draw.dt').on('draw.dt', function () {
    $('#dataGrid .quiz-module-dropdown').each(function () {
      const selectorId = this.id;
      const rowIndex = $(this).data('row');
      const quizData = quizDataTable.row(rowIndex).data();
      populateQuizModules(selectorId, quizData.module_id);
      if (!$(this).hasClass('select2-hidden-accessible')) {
        $(this).select2({ width: '100%' });
      }
    });
  });

  $('#dataGrid').off('click', '.quiz-assign-btn').on('click', '.quiz-assign-btn', function () {
    const quizId = $(this).data('id');
    const row = $(this).closest('tr');
    const moduleId = row.find('.quiz-module-dropdown').val();

    if (!course_id || !moduleId || !quizId) {
      alert('Please ensure Course, Module, and Quiz are selected.');
      return;
    }

    $.ajax({
      url: 'cr/assign_quiz_to_course_api.php',
      type: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({
        course_id: parseInt(course_id),
        module_id: parseInt(moduleId),
        quiz_id: quizId
      }),
      success: function (response) {
        if (response.status === 'success') {
          showAlert(response.message, 'success');
          quizDataTable.ajax.reload();
        } else {
          showAlert(response.message, 'danger');
        }
      },
      error: function () {
        alert('Server error while assigning quiz.');
      }
    });
  });
}

$(document).ready(function () {
  $.ajax({
    url: './apis/module_dropdown_api.php',
    type: 'GET',
    dataType: 'json',
    data: { course_id: course_id },
    success: function(data) {
      if (data && Array.isArray(data.modules)) {
        quizCachedModules = data.modules;
        initQuizTable();
      } else {
        console.error('Invalid response format from module_dropdown_api.php', data);
      }
    },
    error: function(xhr, status, error) {
      console.error('Failed to load modules:', error);
    }
  });
});




// ================= ASSIGNMENT ADD (SINGLE DROPDOWN) =================
let assignmentList = [];

// Populate assignment dropdown from API response
function populateAssignmentDropdown(selectedAssignment = null) {
  let options = '<option value="">Select Assignment</option>';
  if (assignmentList && assignmentList.length) {
    assignmentList.forEach(item => {
      const selectedAttr = (selectedAssignment && selectedAssignment == item.assignment_id) ? 'selected' : '';
      options += `<option value="${item.assignment_id}" ${selectedAttr}>${item.assignment_title}</option>`;
    });
  }
  $('#assignmentDropdown').html(options).trigger('change');
}

// Load assignments via API
function loadAssignments() {
  $.ajax({
    url: 'cr/assignment_api.php',
    type: 'POST',
    dataType: 'json',
    data: { course_id: course_id, draw: 1, start: 0, length: 1000 }, // fetch all
    beforeSend: function () { $('#page-loader').show(); },
    complete: function () { $('#page-loader').hide(); },
    success: function (response) {
      assignmentList = response.data || [];
      const selectedAssignment = response.selectedAssignment || null;
      populateAssignmentDropdown(selectedAssignment);

      // Initialize select2 if not already
      if (!$('#assignmentDropdown').hasClass('select2-hidden-accessible')) {
        $('#assignmentDropdown').select2({ width: '100%' });
      }
    },
    error: function (xhr, status, error) {
      console.error('Error loading assignments:', error);
    }
  });
}

// Handle Assign button click
$('#assignBtn').on('click', function () {
  const assignmentId = $('#assignmentDropdown').val();

  if (!course_id || !assignmentId) {
    alert('Please select Course and Assignment.');
    return;
  }

  $.ajax({
    url: 'cr/assign_assignment_to_course_api.php',
    type: 'POST',
    contentType: 'application/json',
    data: JSON.stringify({
      course_id: parseInt(course_id),
      assignment_id: parseInt(assignmentId)
    }),
    success: function (response) {
      if (response.status === 'success') {
        showAlert(response.message, 'success');
        loadAssignments(); // reload to refresh dropdown and show selected
      } else {
        showAlert(response.message, 'danger');
      }
    },
    error: function () {
      alert('Server error while assigning assignment.');
    }
  });
});

$(document).ready(function () {
  loadAssignments();
});


</script>

<script>
// Skill Input Handler
const input = document.getElementById('skillsInput');
const wrapper = document.getElementById('skillsWrapper');
const hiddenInput = document.getElementById('skillsHiddenInput');
const skills = [];

input.addEventListener('keydown', function (e) {
  if (e.key === 'Enter' || e.key === ',') {
    e.preventDefault();
    const value = input.value.trim();
    if (value && !skills.includes(value)) {
      skills.push(value);
      addSkillTag(value);
      updateHiddenInput();
    }
    input.value = '';
  }
});

function addSkillTag(skill) {
  const span = document.createElement('span');
  span.className = 'skill-tag';
  span.innerHTML = `${skill} <span class="remove-skill">&times;</span>`;
  
  span.querySelector('.remove-skill').addEventListener('click', () => {
    wrapper.removeChild(span);
    const index = skills.indexOf(skill);
    if (index !== -1) skills.splice(index, 1);
    updateHiddenInput();
  });

  wrapper.insertBefore(span, input);
}

function updateHiddenInput() {
  hiddenInput.value = skills.join(',');
}
</script>






<script>
$(document).ready(function () {
  // Check if required fields are filled and enable/disable button
  function checkRequiredFields() {
    const courseTitle = $('#course_title').val()?.trim() || '';
    const courseDescription = $('#course_description').val()?.trim() || '';
    const category = String($('#category').val() || '').trim();
    const licenses = $('#licenses').val() || '';
    const startDate = $('#start_date').val() || '';
    const endDate = $('#end_date').val() || '';

    const allFilled = [courseTitle, courseDescription, category, licenses, startDate, endDate].every(field => field !== '');

    $('#goToTab2').prop('disabled', !allFilled);
  }

  // Initial check (disables button if fields empty)
  checkRequiredFields();

  // Re-check on user input/change
  $('#course_title, #course_description, #category, #licenses, #start_date, #end_date').on('input change', checkRequiredFields);

  // Load course data if editing (course_id must be set globally)
  if (typeof course_id !== 'undefined' && course_id) {
    $.ajax({
      url: './cr/get_course_api.php?course_id=' + course_id,
      method: 'GET',
      dataType: 'json',
      success: function (res) {
        if (res.status === 'success') {
          const data = res.data;
          
          let globalFolderName = data.folder_name;

          $('#course_title').val(data.course_title);
          $('#course_description').val(data.course_description);
          $('#category').val(data.course_category).trigger('change');
          $('#level').val(data.level).trigger('change');
          $('#language').val(data.language).trigger('change');
          $('#licenses').val(data.no_of_licenses);
          $('#course_fees').val(data.course_fees);
          $('#start_date').val(data.start_date);
          $('#end_date').val(data.end_date);
          $('#hours').val(data.hours);

          $('#courseImagePreview').attr('src', 'institutes/' + data.folder_name + '/course_images/' + data.course_img).show();
          $('#skillsHiddenInput').val(data.skills);
          const loadedSkills = data.skills ? data.skills.split(',') : [];
          loadedSkills.forEach(skill => {
            if (skill.trim() !== '' && !skills.includes(skill.trim())) {
              skills.push(skill.trim());
              addSkillTag(skill.trim());
            }
          });

          let learningsArray = JSON.parse(data.learnings || '[]');
          $('#learnings').val(learningsArray.join('\n'));

          $('#mentor').val(data.mentor_ids).trigger('change');
          $('#industry_expert').val(data.industry_expert_ids).trigger('change');
          $('#testimonials').val(data.testimonials).trigger('change');
          $('#proposed_courses').val(data.proposed_courses).trigger('change');
          $('#faqs').val(data.faq_ids).trigger('change');

          // After loading data, re-check fields and update button state
          checkRequiredFields();

        } else {
          alert(res.message);
        }
      },
      error: function (xhr, status, error) {
        console.error(xhr.responseText);
        alert('Error fetching course data.');
      }
    });
  }

  // Navigation buttons
  $('#goToTab2').on('click', function () {
    $('a[href="#tab_2"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
  $('#goToTab3').on('click', function () {
    $('a[href="#tab_3"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
  $('#goToTab4').on('click', function () {
    $('a[href="#tab_4"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
  $('#goToTab5').on('click', function () {
    $('a[href="#tab_5"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });  

  $('#backToTab1').on('click', function () {
    $('a[href="#tab_1"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
  $('#backToTab2').on('click', function () {
    $('a[href="#tab_2"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
  $('#backToTab3').on('click', function () {
    $('a[href="#tab_3"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
  $('#backToTab4').on('click', function () {
    $('a[href="#tab_4"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });  

  // Finish button
  document.getElementById('finishCourse')?.addEventListener('click', function () {
    window.location.href = 'course_master.php';
  });
});
</script>



<script>
$('#goToTab2').on('click', function () {
  // Gather form data
  let formData = new FormData();
  formData.append('course_id', course_id);
  formData.append('course_title', $('#course_title').val());
  formData.append('course_description', $('#course_description').val());
  formData.append('category', $('#category').val());
  formData.append('level', $('#level').val());
  formData.append('language', $('#language').val());
  formData.append('licenses', $('#licenses').val());
  formData.append('course_fees', $('#course_fees').val());
  formData.append('hours', $('#hours').val());
  formData.append('start_date', $('#start_date').val());
  formData.append('end_date', $('#end_date').val());
  formData.append('skills', $('#skillsHiddenInput').val());
  formData.append('learnings', JSON.stringify($('#learnings').val().split('\n')));
  formData.append('mentor', $('#mentor').val());
  formData.append('industry_expert', $('#industry_expert').val());
  formData.append('testimonials', $('#testimonials').val());
  formData.append('proposed_courses', $('#proposed_courses').val());
  formData.append('faqs', $('#faqs').val());

  // Add file if selected
  if ($('#course_image')[0].files.length > 0) {
    formData.append('course_img', $('#course_image')[0].files[0]);
  }

  $.ajax({
    url: './cr/add_course_api.php',
    method: 'POST',
    data: formData,
    processData: false,
    contentType: false,
    dataType: 'json',
    success: function (res) {
      if (res.status === 'success') {
        // Move to next tab
        $('a[href="#tab_2"]').tab('show');
        window.scrollTo({ top: 0, behavior: 'smooth' });
      } else {
        alert('Error: ' + res.message);
      }
    },
    error: function (xhr) {
      console.error(xhr.responseText);
      alert('An error occurred while saving.');
    }
  });
});




$('#goToTab4').on('click', function () {
    $('a[href="#tab_4"]').tab('show');
    window.scrollTo({ top: 0, behavior: 'smooth' });

    $.ajax({
        url: './apis/module_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        data: { course_id: course_id },
        success: function (data) {
            let modules = null;

            if (Array.isArray(data)) {
                modules = data;   // direct array
            } else if (data.modules && Array.isArray(data.modules)) {
                modules = data.modules;
            }

            if (modules) {
                quizCachedModules = modules;

                if (isQuizTableInitialized) {
                    quizDataTable.ajax.reload();
                } else {
                    initQuizTable();
                }
            }
        }
    });
});


// Filter modules as user types
$(document).on('keyup', '#moduleSearch', function () {
  const query = $(this).val().toLowerCase();

  $('#existingModulesList li').each(function () {
    const text = $(this).text().toLowerCase();
    if (text.includes(query)) {
      $(this).show();
    } else {
      $(this).hide();
    }
  });
});

// Reset when modal opens
$('#existingModulesModal').on('shown.bs.modal', function () {
  $('#moduleSearch').val(''); // clear search
  $('#existingModulesList li').show(); // show all again
});


</script>


</body>
</html>