<?php 
$page_name = 'Add Course';

require_once('includes/connection.php');
require_once('includes/header.php');

?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
  .nav-tabs .nav-link {
    background-color: lightgrey;
    color: #5C2C8B;
    border: 1px solid #dee2e6;
    margin-right: 5px;
    border-radius: 5px 5px 0 0;
  }

  .nav-tabs .nav-link.active {
    background-color: #5C2C8B;
    color: white !important;
    border-color: #5C2C8B #5C2C8B #fff;
  }

  .tab-content {
    border: 1px solid #dee2e6;
    border-top: none;
    padding: 20px;
    border-radius: 0 0 5px 5px;
  }

  .tab-pane {
    display: none;
  }

  .tab-pane.active {
    display: block;
  }
</style>

<div id="loaderOverlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(255,255,255,0.7); z-index:9999; text-align:center;">
  <img src="loader.gif" alt="Loading..." style="margin-top:20%;">
</div>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD NEW COURSE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="course_master.php">Course</a></li>
        <li class="active">Add Course</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are  </p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

        <form id="courseForm" enctype="multipart/form-data">
  <div class="box-body">
    <div class="container-fluid">

      <!-- Course Title -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Course Title <span class="text-danger">*</span></label>
        <div class="col-md-9">
          <input class="form-control" type="text" id="course_title" name="course_title"  >
        </div>
      </div>

      <!-- Description -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Description</label>
        <div class="col-md-9">
          <textarea class="form-control" id="description" name="description" rows="4"></textarea>
        </div>
      </div>

      <!-- Category -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Category <span class="text-danger">*</span></label>
        <div class="col-md-9">
          <select class="form-control select2" id="category" name="category"   style="width: 100%;"></select>
        </div>
      </div>

      <!-- Mentor Name -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Mentor Name <span class="text-danger">*</span></label>
        <div class="col-md-9">
          <select class="form-control select2" id="mentor"  multiple="multiple"  name="mentor[]"   style="width: 100%;"></select>
        </div>
      </div>

      <!-- Industry Expert -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Industry Expert <span class="text-danger">*</span></label>
        <div class="col-md-9">
          <select class="form-control select2" id="industry_expert" name="industry_expert"   style="width: 100%;"></select>
        </div>
      </div>

      <!-- Level -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Level <span class="text-danger">*</span></label>
        <div class="col-md-6">
          <select class="form-control select2" id="level" name="level"   style="width: 100%;">
            <option value="1">Level 1</option>
            <option value="2">Level 2</option>
            <option value="3">Level 3</option>
          </select>
        </div>
      </div>

      <!-- Schedules -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Schedules</label>
        <div class="col-md-2 text-center">Select Date To:</div>
        <div class="col-md-3">
          <input class="form-control" type="date" id="schedule_from" name="schedule_from">
        </div>
        <div class="col-md-1 text-center">From:</div>
        <div class="col-md-3">
          <input class="form-control" type="date" id="schedule_to" name="schedule_to">
        </div>
      </div>

      <!-- Testimonials -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Testimonials</label>
        <div class="col-md-9">
          <select class="form-control select2" multiple="multiple" id="testimonial" name="testimonial[]" style="width: 100%;"></select>
        </div>
      </div>

      <!-- Proposed Courses -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Proposed Courses</label>
        <div class="col-md-6">
          <select class="form-control select2" id="proposed_courses" name="proposed_courses" style="width: 100%;"></select>
        </div>
      </div>

      <!-- Course Image -->
      <div class="form-group row">
        <label class="col-md-3 col-form-label">Course Image</label>
        <div class="col-md-9">
          <input class="form-control" type="file" id="course_img" name="course_img" accept="image/png, image/gif, image/jpeg">
        </div>
      </div>

    </div>

    <!-- Footer Buttons -->
    <div class="box-footer text-center mt-4">
      <button type="button" class="btn btn-primary" id="saveDraftBtn">Save As Draft</button>
      <button type="submit" class="btn btn-primary">Save And Next >></button>
      <a href="course_master.php" class="btn btn-secondary">Cancel</a>
    </div>
  </div>
</form>

<div id="section2" style="display: none;">
  <div class="box-header with-border">

    <!-- Add More Module Button -->
    <button type="button" class="btn btn-primary mb-3" onclick="addModuleBlock()">Add More Module</button>
    
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-module"> Show Modules Table </button>



    <div class="box-body">
      <div class="container-fluid" id="moduleContainer">
        
        <!-- Start of one module block -->
        <div class="module-block mb-4">
          <div class="form-group row align-items-center">
            <!-- Module Name -->
            <label class="col-md-2">Module Name <span class="text-danger">*</span></label>
            <div class="col-md-3">
              <input type="text" name="module_name" placeholder="Module Name" class="form-control mb-3" />
            </div>

            <!-- Upload File -->
            <label class="col-md-2">Upload File <span class="text-danger">*</span></label>
            <div class="col-md-3">
              <div class="moduleContentWrapper mb-3">
                <input type="file" name="module_file" class="form-control me-2 mb-3" />
              </div>
            </div>

            <!-- + Button -->
            <div class="col-md-2">
              <button type="button" class="btn btn-primary btn-circle" onclick="addModuleContent(this)" style="border-radius: 50% !important;">Add</button>  
            </div>
              <button type="button" class="btn btn-primary btn-circle" onclick="addModuleContent(this)">Add More content</button>  
            </div>            
          </div>
        </div>
        <!-- End of one module block -->

      </div>
    </div>

    <!-- Footer Buttons -->
    <div class="box-footer d-flex justify-content-center gap-2 mt-4 flex-wrap">
      <button type="button" class="btn btn-secondary" onclick="goBackToSection1()">Back</button>        
      <button type="button" class="btn btn-primary" id="saveDraftBtn">Save Draft</button>
      <button type="button" class="btn btn-primary" onclick="goToSection3()">Next >></button>
    </div>
  </div>
</div>





<!-- Section 3 -->
<div id="section3" style="display: none;">
  <div class="box-header with-border">

    <!-- Add More Sub Module Button -->
    <button type="button" class="btn btn-primary mb-3" onclick="addSubModuleBlock()">Add More Sub Module</button>
    
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modal-submodule">
              Show SubModules Table
            </button>


    <div class="box-body">
      <div class="container-fluid" id="subModuleContainer">
        
        <!-- Start of one sub module block -->
        <div class="sub-module-block mb-4">
          <div class="form-group row align-items-center">
            <!-- Sub Module Name -->
            <label class="col-md-2">Sub Module Name <span class="text-danger">*</span></label>
            <div class="col-md-3">
              <input type="text" name="sub_module_name[]" placeholder="Sub Module Name" class="form-control mb-3" />
            </div>

            <!-- Upload File -->
            <label class="col-md-2">Upload File <span class="text-danger">*</span></label>
            <div class="col-md-3">
              <div class="subModuleContentWrapper mb-3">
                <input type="file" name="sub_module_file[0][]" class="form-control me-2 mb-3" />
              </div>
            </div>

            <!-- + Button -->
            <div class="col-md-2">
              <button type="button" class="btn btn-primary btn-circle" onclick="addSubModuleContent(this)" style="border-radius: 50% !important;"><i class="fas fa-plus"></i></button>  
            </div>
          </div>
        </div>
        <!-- End of one sub module block -->

      </div>
    </div>

    <!-- Footer Buttons -->
    <div class="box-footer d-flex justify-content-center gap-2 mt-4 flex-wrap">
      <button type="button" class="btn btn-secondary" onclick="goBackToSection2()">Back</button>
      <button type="submit" class="btn btn-primary">Submit</button>
    </div>
  </div>
</div>










      </div>
    </section>
  </div>
  
  <!-- Modal -->
<div class="modal fade" id="modal-module">
  <div class="modal-dialog modal-lg"> <!-- 'modal-lg' for large size -->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Modules Table</h4>
      </div>
      <div class="modal-body">
        <div id="loader" style="display: none;">Loading...</div>
        <table id="dataGrid" class="table table-bordered">
          <thead style="background: #FAF7FE;">
            <tr>
              <th><input type="checkbox" id="selectAllModule" /></th>
              <th>Sr. No.</th>
              <th>Module</th>
              <th>Sub Modules</th>
              <th>Description</th>
            </tr>
          </thead>
          <tbody>
            <!-- Populated by JavaScript -->
          </tbody>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary pull-left" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary pull-left">Submit</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modal-submodule">
  <div class="modal-dialog modal-lg"> <!-- 'modal-lg' for large size -->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">SubModules Table</h4>
      </div>
      <div class="modal-body">
        <div id="loader" style="display: none;">Loading...</div>
        <table id="dataGrid" class="table">
                    <thead style="background: #FAF7FE;">
                        <tr>
                        <th class="wd-20"><input type="checkbox" id="selectAllSubModule" /></th>
                          <th class="wd-20">Sr. No.</th>
                          <th class="wd-20">Submodule</th>
                          <th class="wd-40">Description</th>
                        </tr>
                    </thead>
                        <tbody>
                        
                        </tbody>
                    </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary pull-left" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary pull-left">Submit</button>
      </div>
    </div>
  </div>
</div>



<?php require_once('includes/footer.php'); ?>


<script src="js/dropdown_helpers.js"></script>



<script>
$(document).ready(function () {
    populateAllDropdowns('apis/dropdown_api.php');
});
</script>

<script>
  // Go from Section 1 to Section 2
  function goToSection2() {
    document.getElementById('courseForm').style.display = 'none';
    document.getElementById('section2').style.display = 'block';
  }

  // Go back to Section 1 from Section 2
  function goBackToSection1() {
    document.getElementById('section2').style.display = 'none';
    document.getElementById('courseForm').style.display = 'block';
  }

  // Go to Section 3 from Section 2
  function goToSection3() {
    document.getElementById('section2').style.display = 'none';
    document.getElementById('section3').style.display = 'block';
  }

  // Go back to Section 2 from Section 3
  function goBackToSection2() {
    document.getElementById('section3').style.display = 'none';
    document.getElementById('section2').style.display = 'block';
  }

  // Hook form submission of Section 1
  document.querySelector('#courseForm').addEventListener('submit', function (e) {
    e.preventDefault(); // Prevent default submit
    goToSection2();     // Go to module section
  });
</script>

<script>
  function addModuleBlock() {
    const container = document.getElementById('moduleContainer');
    const blocks = container.getElementsByClassName('module-block');
    const lastBlock = blocks[blocks.length - 1];
    const clone = lastBlock.cloneNode(true);

    // Clear input values in the cloned block
    const inputs = clone.querySelectorAll('input');
    inputs.forEach(input => input.value = '');

    // Clear existing uploaded files if any
    const wrappers = clone.querySelectorAll('.moduleContentWrapper');
    wrappers.forEach(wrapper => {
      wrapper.innerHTML = `
        <input type="file" name="module_file1[0][]" class="form-control me-2 mb-3" />
      `;
    });

    container.appendChild(clone);
  }

//   function addModuleContent(button) {
//     const wrapper = button.closest('.module-block').querySelector('.moduleContentWrapper');

//     const contentRow = document.createElement('div');
//     contentRow.className = 'row align-items-center mb-3';

//     contentRow.innerHTML = `
//       <div class="col-md-10">
//         <input type="file" name="module_file1[0][]" class="form-control" />
//       </div>
//       <div class="col-md-2 d-flex justify-content-center">
//         <button type="button" class="btn btn-danger rounded-circle" onclick="removeModuleContent(this)" style="width: 35px; height: 35px;">
//           <i class="fas fa-minus"></i>
//         </button>
//       </div>
//     `;

//     wrapper.appendChild(contentRow);
//   }

  function removeModuleContent(button) {
    const row = button.closest('.row');
    if (row) row.remove();
  }
</script>

<script>
  function encodeModuleId(id) {
    return btoa(id); // Replace with your actual encryption logic
  }

  async function fetchData() {
    try {
      $('#loader').show();
      const response = await $.ajax({
        url: 'apis/module_api.php',
        method: 'GET',
        dataType: 'json'
      });

      const tableBody = $('#dataGrid tbody');
      tableBody.empty();

      let tableRows = '';

      $.each(response, function(index, item) {
        const encryptedId = encodeModuleId(item.module_id);

        tableRows += `
          <tr>
            <td><input type="checkbox" class="row-checkbox" /></td>
            <td>${index + 1}</td>
            <td>${item.module_name}</td>
            <td>${item.submodule_names}</td>
            <td>${item.description}</td>
          </tr>
        `;
      });

      tableBody.html(tableRows);
      $('#loader').hide();
    } catch (error) {
      console.error('Error fetching data:', error);
      $('#loader').hide();
    }
  }

  // Fetch data when modal is shown
  $('#modal-module').on('shown.bs.modal', fetchData);

  // Select/Deselect All checkboxes
  $(document).on('change', '#selectAllModule', function () {
    $('.row-checkbox').prop('checked', this.checked);
  });
</script>

<script>
  function updateSubModuleIndexes() {
    const blocks = document.querySelectorAll('#subModuleContainer .sub-module-block');
    blocks.forEach((block, index) => {
      block.setAttribute('data-index', index);
      const inputs = block.querySelectorAll('.subModuleContentWrapper input[type="file"]');
      inputs.forEach(input => {
        input.name = `sub_module_file[${index}][]`;
      });
    });
  }

  function addSubModuleBlock() {
    const container = document.getElementById('subModuleContainer');
    const blocks = container.querySelectorAll('.sub-module-block');
    const lastBlock = blocks[blocks.length - 1];
    const clone = lastBlock.cloneNode(true);

    // Reset text input values
    clone.querySelector('input[type="text"]').value = '';

    // Reset file inputs
    const wrapper = clone.querySelector('.subModuleContentWrapper');
    wrapper.innerHTML = `
      <input type="file" class="form-control me-2 mb-3" />
    `;

    container.appendChild(clone);
    updateSubModuleIndexes(); // Recalculate file names
  }

  function addSubModuleContent(button) {
    const block = button.closest('.sub-module-block');
    const wrapper = block.querySelector('.subModuleContentWrapper');
    const index = block.getAttribute('data-index');

    const newFileRow = document.createElement('div');
    newFileRow.className = 'row align-items-center mb-3';

    newFileRow.innerHTML = `
      <div class="col-md-10">
        <input type="file" name="sub_module_file[${index}][]" class="form-control" />
      </div>
      <div class="col-md-2 d-flex justify-content-center">
        <button type="button" class="btn btn-danger rounded-circle" onclick="removeSubModuleContent(this)" style="width: 35px; height: 35px;">
          <i class="fas fa-minus"></i>
        </button>
      </div>
    `;

    wrapper.appendChild(newFileRow);
  }

  function removeSubModuleContent(button) {
    const row = button.closest('.row');
    if (row) row.remove();
  }
</script>

<script>
  function encodeSubmoduleId(submoduleId) {
        return btoa(submoduleId.toString());
    }

  async function fetchSubModuleData() {
    try {
      $('#loader').show();

      const response = await $.ajax({
        url: 'apis/submodule_api.php', // Make sure this returns JSON
        method: 'GET',
        dataType: 'json'
      });

      const tableBody = $('#dataGrid tbody');
      tableBody.empty();

      let tableRows = '';

      $.each(response, function(index, item) {
        const encryptedId = encodeSubmoduleId(item.submodule_id);

        tableRows += `
          <tr>
            <td><input type="checkbox" class="row-checkbox" data-id="${encryptedId}" /></td>
            <td>${index + 1}</td>
            <td>${item.submodule_name}</td>
            <td>${item.description}</td>
          </tr>
        `;
      });

      tableBody.html(tableRows);
      $('#loader').hide();
    } catch (error) {
      console.error('Error fetching submodule data:', error);
      $('#loader').hide();
    }
  }

  // Fetch submodule data when modal opens
  $('#modal-submodule').on('shown.bs.modal', fetchSubModuleData);

  // Select/Deselect All checkboxes
  $(document).on('change', '#selectAllSubModule', function () {
    $('.row-checkbox').prop('checked', this.checked);
  });
  
  
  
$(document).ready(function () {
  let saveAsDraft = false;
  $('#saveDraftBtn').on('click', function () {
    saveAsDraft = true;
    $('#courseForm').submit();
  });

  $('#courseForm').on('submit', function (e) {
    e.preventDefault();

    var formData = new FormData(this);
    formData.append('is_draft', saveAsDraft ? 1 : 0);
    $.ajax({
      url: 'apis/add_course_draft_api.php',
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      beforeSend: function () {
        console.log("Submitting...");
      },
      success: function (response) {
        console.log(response);
        if (response.status === 'success') {
          alert(response.message);

          if (saveAsDraft) {
            saveAsDraft = false;
          } else {
            goToSection2();
          }
        } else {
          alert("Error: " + response.message);
        }
      },
      error: function (xhr, status, error) {
        console.error(xhr.responseText);
        alert("Something went wrong. Please try again.");
      }
    });
  });
});


function addModuleContent(button) {
  const moduleBlock = button.closest('.module-block');
  const moduleName = moduleBlock.querySelector('input[name="module_name"]').value;
  const fileInput = moduleBlock.querySelector('input[type="file"]');

  if (!moduleName || !fileInput.files.length) {
    alert("Please enter module name and select a file.");
    return;
  }

  const formData = new FormData();
  formData.append('module_name', moduleName);
  formData.append('study_file', fileInput.files[0]);

  $.ajax({
    url: 'apis/add_module_content_api.php',
    type: 'POST',
    data: formData,
    contentType: false,
    processData: false,
    beforeSend: function () {
      $('#loaderOverlay').show(); // Show loader
    },
    success: function (response) {
      console.log(response);
      const res = JSON.parse(response);
      if (res.success) {
        alert("Module and file saved!");
        fileInput.value = ""; // Clear file input
      } else {
        alert("Error: " + res.message);
      }
    },
    error: function (xhr) {
      console.error(xhr.responseText);
      alert("An error occurred while saving.");
    },
    complete: function () {
      $('#loaderOverlay').hide();
    }
  });
}


  
</script>

</body>
</html>