<?php 
$page_name = 'Add FAQ';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD FAQ
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="faq_master.php">FAQ</a></li>
        <li class="active">Add FAQ</li>
      </ol>
    </section>
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

        <form id="faqForm">
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>FAQ Question <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="faq_question" name="faq_question" rows="3" required></textarea>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>FAQ Answer </label>
                            <textarea class="form-control" id="faq_answer" name="faq_answer" rows="3"></textarea>
                        </div>
                    </div>
                </div>

                <div class="row">  
                    <div class="col-md-6">
                        <div class="form-group">
                          <div class="radio">
                              <input name="block_mentor" value="1" type="radio" id="Option_1" class="with-gap radio-col-red">
                              <label for="Option_1">Block FAQ</label>                    
                          </div>
                          <div class="radio">
                              <input name="block_mentor" value="0" type="radio" id="Option_2" class="with-gap radio-col-red" checked="">
                              <label for="Option_2">Unblock FAQ</label>   
                          </div>
                        </div>
                    </div>
                </div>

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="faq_master.php" class="btn btn-secondary">Back</a>
                </div>
            </div>
        </form>
      </div>
    </section>
  </div>

<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
    $('#faqForm').on('submit', function(event) {
        event.preventDefault();
        
        var formData = {
            faq_question: $('#faq_question').val(),
            faq_answer: $('#faq_answer').val(),
            is_block: $('input[name="is_block"]:checked').val()
        };

        $.ajax({
            url: 'apis/add_faq_api.php',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showAlert(response.message, 'success');
                    $('#faqForm')[0].reset();
                } else {
                    showAlert(response.message, 'danger');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                showAlert('An error occurred while submitting the form.', 'danger');
            }
        });
    });

    function showAlert(message, type) {
        $('#responseMessage').html('<div class="alert alert-' + type + '">' + message + '</div>');
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 3000);
    }
});
</script>
