<?php 
$page_name = 'Add Course';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">ADD COURSE</span>
    <ol class="breadcrumb">
      <button type="button" class="btn btn-block btn-success btn-flat">
        Draft No : <?php echo isset($_GET['draft']) ? intval($_GET['draft']) : 0 ?>
      </button>
    </ol>
  </section>

  <section class="content">
    <div class="box box-default">
      <div class="row">
        <div class="col-md-12">
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                  <li class="active"><a href="#tab_1" class="tab-link" data-toggle="tab">Course Details</a></li>
                  <li><a href="#tab_2" class="tab-link" data-toggle="tab">Modules And Course materials</a></li>
                  <li><a href="#tab_3" class="tab-link" data-toggle="tab">Submodules And Course materials</a></li>
                  <li><a href="#tab_4" class="tab-link" data-toggle="tab">Quiz</a></li>
                </ul>


            <div class="tab-content">
              <!-- TAB 1 -->
              <div class="tab-pane active" id="tab_1">
                <form id="courseForm" enctype="multipart/form-data">
                  <div class="box-body">
                    <div class="container-fluid">
                      <input type="hidden" name="draft_id" value="<?php echo $_GET['draft']; ?>">

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Title <span class="text-danger">*</span></label>
                        <div class="col-md-9">
                          <input class="form-control" type="text" id="course_title" name="course_title">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Description</label>
                        <div class="col-md-9">
                          <textarea class="form-control" id="course_description" name="course_description" rows="4"></textarea>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Category</label>
                        <div class="col-md-9">
                          <select class="form-control select2 category" id="category" name="category" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Mentor Name</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="mentor" multiple name="mentor[]" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Level</label>
                        <div class="col-md-6">
                          <select class="form-control select2" id="level" name="level" style="width: 100%;">
                            <option value="1">Level 1</option>
                            <option value="2">Level 2</option>
                            <option value="3">Level 3</option>
                          </select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">No Of Licenses</label>
                        <div class="col-md-9">
                          <input class="form-control" type="number" id="no_of_license" name="no_of_license">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Fees</label>
                        <div class="col-md-9">
                          <input class="form-control" type="number" id="course_fees" name="course_fees">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Language</label>
                        <div class="col-md-6">
                          <select class="form-control select2" id="language" name="language" style="width: 100%;">
                            <option value="english">English</option>
                            <option value="marathi">Marathi</option>
                            <option value="hindi">Hindi</option>
                          </select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Schedules</label>
                        <div class="col-md-2 text-center">From:</div>
                        <div class="col-md-3">
                          <input class="form-control" type="date" id="schedule_from" name="schedule_from">
                        </div>
                        <div class="col-md-1 text-center">To:</div>
                        <div class="col-md-3">
                          <input class="form-control" type="date" id="schedule_to" name="schedule_to">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Testimonials</label>
                        <div class="col-md-9">
                          <select class="form-control select2" multiple id="testimonial" name="testimonial[]" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Proposed Courses</label>
                        <div class="col-md-6">
                          <select class="form-control select2" multiple id="proposed_courses" name="proposed_course[]" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Image</label>
                        <div class="col-md-9">
                          <input class="form-control" type="file" id="course_img" name="course_img" accept="image/*">
                        </div>
                      </div>
                    </div>

                    <div class="box-footer text-center mt-4">
                      <button type="button" id="goToTab2" class="btn btn-primary">Save And Next >></button>
                      <button type="button" class="btn btn-secondary" onclick="window.location.href='course_master.php'">Cancel</button>
                    </div>
                  </div>
                </form>
              </div>

              <!-- TAB 2: MODULES -->
              <div class="tab-pane" id="tab_2">
    <table id="dataGrid" class="table">
        <thead style="background: #FAF7FE;">
            <tr>
                <th class="wd-20">Drag</th>
                <th class="wd-20">Sr. No.</th>
                <th class="wd-20">Module</th>
                <!--<th class="wd-20"><input type="checkbox" disabled style="margin-top: -15px;"></th>-->
            </tr>
        </thead>
        <tbody>
            </tbody>
    </table>

    <div class="mb-3">
        <button type="button" class="btn btn-info" data-toggle="modal" data-target="#selectModuleModal">
            Select Module
        </button>
    </div>

    <form id="moduleForm">
        <div class="box-body">
            <div class="row" id="contentWrapper">
                <div class="content-block row">
                    <div class="col-md-1">
                        <button type="button" class="btn btn-primary mb-25 mt-25" id="addMoreModule"><i class="fas fa-plus"></i></button>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Module Name <span class="text-danger">*</span></label>
                            <input class="form-control module-name" type="text" name="module_name[]" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Study Material Title <span class="text-danger">*</span></label>
                            <input class="form-control" type="text" name="vidtitle[]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Upload File <span class="text-danger">*</span></label>
                            <input class="form-control" type="file" name="study_files[]" accept="video/*,application/pdf,image/*" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-primary mb-25 mt-25 btn-circle addMorecontent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                    </div>
                </div>
            </div>

            <div class="box-footer">
                <button type="button" id="goToTab3" class="btn btn-primary">Save And Next >></button>
                <button type="button" id="goToTab1" class="btn btn-secondary"><< Back</button>
            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="selectModuleModal" tabindex="-1" role="dialog" aria-labelledby="selectModuleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="selectModuleModalLabel">Select Modules</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="modulesTableInModal" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th style="width: 50px;"><input type="checkbox" id="selectAllModules"></th>
                            <th>Module Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        </tbody>
                </table>
                <div id="modalModuleLoader" style="display: none; text-align: center; padding: 20px;">
                    <i class="fa fa-spinner fa-spin fa-2x"></i> Loading modules...
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="addSelectedModulesBtn">Add Selected Modules</button>
            </div>
        </div>
        </div>
    </div>

              <!-- TAB 3 -->
              <div class="tab-pane" id="tab_3">
    <form id="submoduleForm">
        <div class="box-body">
            <div class="row" id="contentWrapperSubModule">
                <div class="content-block row">
                    <div class="col-md-1">
                        <button type="button" class="btn btn-primary mb-25 mt-25" id="addMoreSubModule"><i class="fas fa-plus"></i></button>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Modules</label>
                            <select class="form-control select2 module-name-dropdown" id="module_name_id" name="module_name_id" data-placeholder="Select Module" style="width: 100%;">
                                <option value="">Select a Module</option>
                                </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Submodule Name <span class="text-danger">*</span></label>
                            <input class="form-control submodule-name-input" type="text" name="submodule_name[]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Study Material Title <span class="text-danger">*</span></label>
                            <input class="form-control" type="text" name="vidtitlesub[]" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Upload File <span class="text-danger">*</span></label>
                            <input class="form-control" type="file" name="study_files_sub[]" accept="video/*,application/pdf,image/*" required>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-primary mb-25 mt-25 btn-circle addMoreSubContent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <button type="button" class="btn btn-info" id="selectExistingSubmoduleBtn" data-toggle="modal" data-target="#selectSubmoduleModal">
                    Select Existing Submodule
                </button>
            </div>

            <div class="box-footer">
                <button type="button" id="goToTab4" class="btn btn-primary">Save And Next >></button>
                <button type="button" id="goToTab02" class="btn btn-secondary"><< Back</button>
            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="selectSubmoduleModal" tabindex="-1" role="dialog" aria-labelledby="selectSubmoduleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="selectSubmoduleModalLabel">Select Existing Submodules</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="modalParentModuleSelect">Select Parent Module:</label>
                    <select class="form-control select2" id="modalParentModuleSelect" style="width: 100%;">
                        <option value="">Select a Parent Module</option>
                        </select>
                </div>
                <hr>
                <table id="submodulesTableInModal" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th style="width: 50px;"><input type="checkbox" id="selectAllSubmodules"></th>
                            <th>Submodule Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td colspan="2" class="text-center">Select a parent module above to load submodules.</td></tr>
                    </tbody>
                </table>
                <div id="modalSubmoduleLoader" style="display: none; text-align: center; padding: 20px;">
                    <i class="fa fa-spinner fa-spin fa-2x"></i> Loading submodules...
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="addSelectedSubmodulesBtn">Add Selected Submodules</button>
            </div>
        </div>
    </div>
</div>

              <!-- TAB 4 -->
              <div class="tab-pane" id="tab_4">
                <table id="quizDataGrid" class="display table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Sr. No.</th>
                      <th>Quiz Title</th>
                      <th>Module</th>
                      <th>Submodule</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
                <div id="loader" style="display:none;">Loading...</div>


              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<!-- jQuery UI -->
<script src="https://code.jquery.com/ui/1.13.0/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.0/themes/base/jquery-ui.css">


<!-- Bootstrap JS (v3 or v4 depending on your CSS) -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<!-- OR for Bootstrap 4 -->
<!-- <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script> -->


<!--for course-->
<script>

$(document).ready(function () {
    
//     $('.tab-link').on('click', function (e) {
//     e.preventDefault();
//     e.stopImmediatePropagation(); 
//     return false; 
//   });
  
  // Tab navigation
  $('#goToTab1').on('click', function () {
    $('a[href="#tab_1"]').tab('show');
  });
  $(document).ready(function () {
  $('#goToTab2').on('click', function () {
    const courseTitle = $('#course_title').val().trim();
    const category = $('#category').val();

    if (courseTitle === '' || category === '') {
      alert('Please fill out both Course Title and Category before proceeding.');
      return;
    }

    const formData = new FormData($('#courseForm')[0]);

    $.ajax({
  url: 'apis/save_course_draft.php',
  type: 'POST',
  data: formData,
  contentType: false,
  processData: false,
  dataType: 'json', // 👈 Important
  success: function (res) {
    if (res.success) {
      $('a[href="#tab_2"]').tab('show');
    } else {
      alert('Error saving data: ' + res.message);
    }
  },
  error: function () {
    alert('AJAX error while saving data.');
  }
});

  });
});



 
  $('#goToTab02').on('click', function () {
    $('a[href="#tab_2"]').tab('show');
  });
  
  
  $('#goToTab3').on('click', function () {
    $('a[href="#tab_3"]').tab('show');
  });
  
  $('#goToTab4').on('click', function () {
    $('a[href="#tab_4"]').tab('show');
  });
 

  

  
    $.ajax({
        url: 'apis/module_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (Array.isArray(data)) {
                let options = '';
                $.each(data, function(index, submodule) {
                    options += `<option value="${submodule.module_id}">${submodule.module_name}</option>`;
                });
                $('#module_name_id').html(options);

                // Initialize Select2 after adding the options
                $('#module_name_id').select2();
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function(error) {
            console.error('Error occurred while fetching data:', error);
        }
    });
    
    
    
    
    
    
    
    
    
    
    

 

    
   
   
   
  const draftId = "<?php echo $_GET['draft']; ?>";

  if (draftId) {
    $.ajax({
      url: 'apis/get_course_single_api.php',
      method: 'GET',
      data: { draft: draftId },
      dataType: 'json',
      success: function (response) {
        if (response.status === 'success') {
          const course = response.course;

          $('#course_title').val(course.course_title);
          $('#course_description').val(course.course_description);
          $('#category').val(course.course_category).trigger('change');
          $('#mentor').val(course.mentor_ids ? course.mentor_ids.split(',') : []).trigger('change');
          $('#level').val(course.level).trigger('change');
          $('#no_of_license').val(course.no_of_licenses);
          $('#course_fees').val(course.course_fees);
          $('#language').val(course.language).trigger('change');
          $('#schedule_from').val(course.start_date);
          $('#schedule_to').val(course.end_date);
          $('#testimonial').val(course.testimonials ? course.testimonials.split(',') : []).trigger('change');
          $('#proposed_courses').val(course.proposed_courses ? course.proposed_courses.split(',') : []).trigger('change');
          // Optional: display current image name or thumbnail if needed
          if (course.course_img) {
              const imagePath = `images/course_image/${course.course_img}`;
              $('#course_img').after(`
                <div class="mt-2">
                  <p>Current Image:</p>
                  <img src="${imagePath}" alt="Course Image" style="max-width: 200px; border: 1px solid #ccc; padding: 5px;" />
                </div>
              `);
            }

        } else {
          alert(response.message || 'Failed to load course details');
        }
      },
      error: function () {
        alert('Error fetching course details');
      }
    });
  }    
  
  
  
async function fetchData(draftId) {
    try {
        $('#loader').show();

        const response = await $.ajax({
            url: 'apis/draft_module_api.php',
            method: 'GET',
            data: { draft_id: draftId }, // Pass draft_id here
            dataType: 'json'
        });

        const tableBody = $('#dataGrid tbody');
        tableBody.empty();

        let tableRows = '';

        $.each(response, function(index, item) {
            tableRows += `
                <tr data-module-id="${item.module_id}">
                    <td class="drag-handle" style="cursor: move;"><i class="fa fa-bars"></i></td>
                    <td class="drag-handle">${index + 1}</td>
                    <td>${item.module_name}</td>
   
                </tr>
            `;
        });

        tableBody.html(tableRows);

        tableBody.sortable({
            handle: '.drag-handle',
            placeholder: 'ui-state-highlight',
            update: function (event, ui) {
                const newOrder = tableBody.children().map(function () {
                    return $(this).data('module-id');
                }).get();
                console.log("New Order:", newOrder);
            }
        }).disableSelection();

        $('#loader').hide();

    } catch (error) {
        console.error('Error fetching data:', error);
        $('#loader').hide();
    }
}


    
    fetchData(draftId);
    
});
</script>

 <!--for module-->
<script>
    $(document).ready(function () {
    const draftId = $('input[name="draft_id"]').val();

    // Utility: Generate HTML for a blank module input row
    function getBlankModuleHTML() {
        return `
            <div class="content-block row border p-3 mb-3" data-module-id="new">
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4">
                    <button type="button" class="btn btn-primary mb-25 mt-25 leftToggleBtn">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Module Name <span class="text-danger">*</span></label>
                        <input class="form-control module-name" type="text" name="module_name[]" placeholder="Module Name" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Study Material Title <span class="text-danger">*</span></label>
                        <input class="form-control vid-title-input" type="text" name="vidtitle[]" placeholder="Study Material Title" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input class="form-control file-input" type="file" name="study_files[]" accept="video/*,application/pdf,image/*" required>
                    </div>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-primary mt-25 btn-circle addMorecontent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                </div>
            </div>`;
    }

    // Utility: Generate HTML for an existing module row (read-only module name)
    function getExistingModuleHTML(moduleId, moduleName) {
        return `
            <div class="content-block row border p-3 mb-3" data-module-id="${moduleId}">
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4">
                    <button type="button" class="btn btn-danger mb-25 mt-25 removeModuleBtn">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Module Name <span class="text-danger">*</span></label>
                        <input class="form-control module-name" type="text" name="module_name[]" value="${moduleName}" readonly>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Study Material Title <span class="text-danger">*</span></label>
                        <input class="form-control vid-title-input" type="text" name="vidtitle[]" placeholder="Study Material Title" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input class="form-control file-input" type="file" name="study_files[]" accept="video/*,application/pdf,image/*" required>
                    </div>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-primary mt-25 btn-circle addMorecontent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                </div>
            </div>`;
    }

    // Utility: Generate HTML for an unsaved, removable module row
    function getUnsavedRemovableModuleHTML(moduleName = '') {
        return `
            <div class="content-block row border p-3 mb-3" data-module-id="new">
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4">
                    <button type="button" class="btn btn-danger mb-25 mt-25 removeModuleBtn">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Module Name <span class="text-danger">*</span></label>
                        <input class="form-control module-name" type="text" name="module_name[]" placeholder="Module Name" value="${moduleName}" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Study Material Title <span class="text-danger">*</span></label>
                        <input class="form-control vid-title-input" type="text" name="vidtitle[]" placeholder="Study Material Title" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input class="form-control file-input" type="file" name="study_files[]" accept="video/*,application/pdf,image/*" required>
                    </div>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-primary mt-25 btn-circle addMorecontent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                </div>
            </div>`;
    }

    // Function to ensure a blank module is always present at the end of the contentWrapper
    function ensureBlankModuleAtEnd() {
        const $lastBlock = $('#contentWrapper .content-block').last();
        // A block is considered "truly blank" if its data-module-id is "new"
        // AND its module name input is empty. This prevents adding multiple blank rows.
        const isLastBlockTrulyBlank = $lastBlock.length > 0 &&
                                      $lastBlock.data('module-id') === 'new' &&
                                      $lastBlock.find('input.module-name').val() === '';

        if (!isLastBlockTrulyBlank) {
            $('#contentWrapper').append(getBlankModuleHTML());
        }
    }

    // Function to update the left button of a "new" module block to a "minus" button
    function convertNewModuleToRemovable($moduleBlock) {
        $moduleBlock.find('.leftToggleBtn')
            .removeClass('btn-primary leftToggleBtn') // Remove old class
            .addClass('btn-danger removeModuleBtn')    // Add new class
            .find('i')
            .removeClass('fa-plus')
            .addClass('fa-minus');
    }

    // --- Initial Loading Logic ---
    if (draftId) {
        $.ajax({
            url: 'apis/get_modules_by_draft.php',
            type: 'GET',
            data: { draft_id: draftId },
            dataType: 'json', // Expect JSON response
            success: function (res) {
                $('#contentWrapper').empty(); // Clear existing content
                if (res.success && Array.isArray(res.modules) && res.modules.length > 0) {
                    res.modules.forEach(module => {
                        const moduleId = module.module_id; // Use module_id from API for existing modules

                        // Create the module block for the existing module using the new function
                        const $moduleBlock = $(getExistingModuleHTML(moduleId, module.module_name));
                        $('#contentWrapper').append($moduleBlock);

                        // Append existing contents for this module as readonly rows
                        if (module.contents && module.contents.length > 0) {
                            module.contents.forEach(content => {
                                const contentId = content.study_material_id;
                                let contentHTML = `
                                    <div class="row extra-content-row mt-2" data-content-id="${contentId}" data-module-id="${moduleId}">
                                        <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4"></div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <input class="form-control" type="text" value="${module.module_name}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <input class="form-control" type="text" value="${content.title}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input class="form-control" type="text" value="${content.actual_file_name}" readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <button type="button" class="btn btn-danger mt-25 btn-circle removeContent" style="border-radius: 50%"><i class="fas fa-minus"></i></button>
                                        </div>
                                    </div>`;
                                // Insert after the current module block to keep contents grouped
                                $moduleBlock.after(contentHTML);
                            });
                        }
                    });
                }
                // Always ensure one blank row at the end with "+" visible after loading existing modules
                ensureBlankModuleAtEnd();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (get_modules_by_draft.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Failed to fetch existing modules.');
                // If loading fails, still provide an initial blank module
                $('#contentWrapper').empty();
                ensureBlankModuleAtEnd();
            }
        });
    } else {
        // If no draftId, just append an initial blank module
        ensureBlankModuleAtEnd();
    }

    // --- Event Handlers ---

    // Event handler for left button on blank/new module rows
    $(document).on('click', '.leftToggleBtn', function () {
        const $currentModuleBlock = $(this).closest('.content-block');

        // Convert the current block's left button from '+' to '-'
        convertNewModuleToRemovable($currentModuleBlock);

        // Append a brand new blank module row after the current one
        $currentModuleBlock.after(getBlankModuleHTML());

        // Ensure the very last block always has a '+' if it's truly blank
        ensureBlankModuleAtEnd();
    });

    // Remove module row (left side - for existing modules/saved modules, and now unsaved blank ones)
    $(document).on('click', '.removeModuleBtn', function () {
        const $moduleBlock = $(this).closest('.content-block');
        const moduleId = $moduleBlock.data('module-id');
        const moduleName = $moduleBlock.find('input.module-name').val();

        // Handle unsaved blank modules (moduleId === 'new')
        if (moduleId === 'new') {
            if (confirm("Are you sure you want to delete this unsaved module row?")) {
                $moduleBlock.remove();
                ensureBlankModuleAtEnd(); // Re-ensure a blank module is at the end after removal
            }
            return;
        }

        // Handle saved modules
        if (!confirm("Are you sure you want to delete this entire module and all its contents? This action cannot be undone.")) {
            return;
        }

        // Ajax call to delete module from DB
        $.ajax({
            url: 'apis/delete_draft_module_api.php',
            type: 'POST',
            data: { module_id: moduleId, module_name: moduleName },
            dataType: 'json', // Expect JSON response
            success: function (res) {
                if (res.success) {
                    $moduleBlock.remove();
                    // Also remove any associated content rows that might be orphaned in the DOM
                    $(`div.extra-content-row[data-module-id="${moduleId}"]`).remove();
                    alert('Module deleted successfully.');
                    ensureBlankModuleAtEnd(); // Always ensure a blank module at the end
                } else {
                    alert('Failed to delete module: ' + (res.message || 'Unknown error'));
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (delete_draft_module_api.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Error deleting module: ' + textStatus);
            }
        });
    });

    // Remove content row (right side - button for individual study materials)
    $(document).on('click', '.removeContent', function () {
        if (!confirm("Are you sure you want to delete this study material?")) return;

        const $contentRow = $(this).closest('.extra-content-row');
        const contentId = $contentRow.data('content-id');
        const moduleId = $contentRow.data('module-id');

        // Ajax call to delete content from DB
        $.ajax({
            url: 'apis/delete_draft_content_api.php',
            type: 'POST',
            data: { content_id: contentId, module_id: moduleId },
            dataType: 'json', // Expect JSON response
            success: function (res) {
                if (res.success) {
                    $contentRow.remove();
                    alert('Study material deleted successfully.');
                } else {
                    alert('Failed to delete study material: ' + (res.message || 'Unknown error'));
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (delete_draft_content_api.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Error deleting study material: ' + textStatus);
            }
        });
    });

    // Add more content (main upload and logic for handling the current row)
    $(document).on('click', '.addMorecontent', function () {
        const $btn = $(this);
        const $block = $btn.closest('.content-block');
        const moduleNameInput = $block.find('input.module-name');
        const moduleName = moduleNameInput.val();
        const vidTitleInput = $block.find('input[name="vidtitle[]"]');
        const vidTitle = vidTitleInput.val();
        const fileInput = $block.find('input[type="file"]')[0];
        const file = fileInput.files[0];
        const draftId = $('input[name="draft_id"]').val();

        if (!moduleName || !vidTitle || !file) {
            alert("Please fill all required fields (Module Name, Study Material Title, and Upload File) before adding content.");
            return;
        }

        // Show a loading indicator or disable the button to prevent multiple clicks
        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Adding...');

        const formData = new FormData();
        formData.append('module_name', moduleName);
        formData.append('vidtitle', vidTitle);
        formData.append('study_file', file);
        formData.append('draft_id', draftId);

        let currentModuleId = $block.data('module-id');
        // If the module already has an ID (i.e., it's not a 'new' block), send it
        if (currentModuleId !== 'new') {
            formData.append('module_id', currentModuleId);
        }

        $.ajax({
            url: 'apis/add_module_content_api.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json', // Ensure jQuery parses the response as JSON
            success: function (res) {
                $btn.prop('disabled', false).html('<i class="fas fa-plus"></i>'); // Re-enable button

                if (res.success) {
                    alert('Content uploaded successfully.');
                    const newContentId = res.content_id;
                    const returnedModuleId = res.module_id; // The ID returned by the server
                    

                    // If this was a new module block (data-module-id="new")
                    // then this is the first content for this module.
                    if (currentModuleId === 'new') {
                        moduleNameInput.prop('readonly', true); // Make module name readonly
                        $block.data('module-id', returnedModuleId); // Update the data-module-id for the block

                        // Change the left button from "plus" to "minus" and update its class
                        convertNewModuleToRemovable($block);
                    }

                    // Create the readonly row for the newly added content
                    const readonlyContentRow = `
                        <div class="row extra-content-row mt-2" data-content-id="${newContentId}" data-module-id="${returnedModuleId}">
                            <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4"></div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <input class="form-control" type="text" value="${moduleName}" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <input class="form-control" type="text" value="${vidTitle}" readonly>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input class="form-control" type="text" value="${file.name}" readonly>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <button type="button" class="btn btn-danger mt-25 btn-circle removeContent" style="border-radius: 50%"><i class="fas fa-minus"></i></button>
                            </div>
                        </div>`;

                    // Append the readonly content row directly after the current module block
                    // This is key to keeping content grouped under its parent module block.
                    $block.after(readonlyContentRow);

                    // Clear the content-specific input fields for the current block,
                    // so it's ready to add *more* content to the *same* module.
                    vidTitleInput.val('');
                    fileInput.value = ''; // Clear file input

                    // Crucially, ensure a blank module is always available at the very end
                    ensureBlankModuleAtEnd();

                } else {
                    alert('Upload failed: ' + (res.message || 'Unknown error'));
                    // Re-enable inputs on failure
                    vidTitleInput.prop('disabled', false);
                    $(fileInput).prop('disabled', false);
                    if (currentModuleId === 'new') { // Only re-enable module name if it was newly created and failed
                        moduleNameInput.prop('readonly', false);
                    }
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $btn.prop('disabled', false).html('<i class="fas fa-plus"></i>'); // Re-enable button
                // Re-enable inputs on error
                vidTitleInput.prop('disabled', false);
                $(fileInput).prop('disabled', false);
                // Also re-enable module name if it was a new module being saved and failed
                const currentModuleId = $block.data('module-id');
                if (currentModuleId === 'new') {
                    moduleNameInput.prop('readonly', false);
                }
                console.error("AJAX Error (add_module_content_api.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Upload failed: ' + textStatus + (errorThrown ? ' - ' + errorThrown : '') + '. Please try again.');
            }
        });
    });
});
</script>

 <!--for quiz-->
<script>
// --- Utility Functions ---

function getQueryParam(param) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}

function fetchSubmodules(moduleId, submoduleDropdown, selectedSubId = '') {
    const draftId = getQueryParam('draft');

    if (!moduleId || !draftId) {
        submoduleDropdown.empty().append(`<option value="">Select Submodule</option>`);
        submoduleDropdown.prop('disabled', true);
        return;
    }
    submoduleDropdown.prop('disabled', false);

    $.ajax({
        url: `apis/fetch_draft_submodules.php?module_id=${moduleId}&draft_id=${draftId}`,
        method: 'GET',
        dataType: 'json',
        success: function (response) {
            submoduleDropdown.empty().append(`<option value="">Select Submodule</option>`);
            let submodules = [];

            if (response && response.success && Array.isArray(response.submodules)) {
                submodules = response.submodules;
            } else {
                console.warn("API returned an unexpected structure or no submodules:", response);
            }

            submodules.forEach(sub => {
                const id = sub.id;
                const name = sub.name;
                const selected = (id == selectedSubId) ? 'selected' : '';
                submoduleDropdown.append(`<option value="${id}" ${selected}>${name}</option>`);
            });
            // If no submodules are available for the selected module, disable the dropdown
            if (submodules.length === 0) {
                submoduleDropdown.prop('disabled', true);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error("Error fetching draft submodules:", textStatus, errorThrown, jqXHR.responseText);
            submoduleDropdown.empty().append(`<option value="">Error fetching submodules</option>`);
            submoduleDropdown.prop('disabled', true);
        }
    });
}

// --- Main Data Fetching and Rendering ---

async function fetchQuizData() {
    try {
        $('#loader').show();

        const draftId = getQueryParam('draft');
        if (!draftId) {
            console.error("Error: No 'draft' ID found in the URL. Cannot fetch quiz data or modules.");
            alert("Cannot load quizzes: Draft ID is missing from the URL.");
            $('#loader').hide();
            return;
        }

        // 1. Fetch all available quizzes (base list)
        const quizResponse = await fetch('apis/quiz_api.php');
        if (!quizResponse.ok) {
            const errorText = await quizResponse.text();
            throw new Error(`HTTP error fetching all quizzes! Status: ${quizResponse.status}, Response: ${errorText}`);
        }
        const quizzes = await quizResponse.json();

        // 2. Fetch quiz assignments for the current draft
        const assignmentsResponse = await fetch(`apis/fetch_draft_quizzes.php?draft_id=${draftId}`);
        if (!assignmentsResponse.ok) {
            const errorText = await assignmentsResponse.text();
            throw new Error(`HTTP error fetching quiz assignments for draft! Status: ${assignmentsResponse.status}, Response: ${errorText}`);
        }
        const assignmentsData = await assignmentsResponse.json();

        let draftAssignments = [];
        if (assignmentsData.success && Array.isArray(assignmentsData.assignments)) {
            draftAssignments = assignmentsData.assignments;
        } else {
            console.warn("No quiz assignments found for this draft or API returned an error:", assignmentsData.message);
        }

        // Create a quick lookup map for assignments by quiz_id
        const assignedQuizMap = new Map();
        draftAssignments.forEach(assignment => {
            assignedQuizMap.set(assignment.quiz_id, assignment);
        });

        // 3. Fetch modules linked to the current draft
        const modulesForDraftResponse = await fetch(`apis/get_modules_and_submodules_by_draft.php?draft_id=${draftId}`);
        if (!modulesForDraftResponse.ok) {
            const errorText = await modulesForDraftResponse.text();
            throw new Error(`HTTP error fetching draft modules! Status: ${modulesForDraftResponse.status}, Response: ${errorText}`);
        }
        const modulesForDraftData = await modulesForDraftResponse.json();

        let draftModules = [];
        if (modulesForDraftData.success && Array.isArray(modulesForDraftData.modules)) {
            draftModules = modulesForDraftData.modules;
        } else {
            console.warn("No modules found for this draft or API returned an error:", modulesForDraftData.message);
        }

        const moduleOptionsHtml = draftModules.map(mod =>
            `<option value="${mod.module_id}">${mod.module_name}</option>`
        ).join('');

        const tableBody = $('#quizDataGrid tbody');
        tableBody.empty(); // Clear any existing table rows

        // Iterate through each quiz to build and append its row
        quizzes.forEach((quiz, index) => {
            // Check if this quiz is already assigned to the current draft
            const assignment = assignedQuizMap.get(quiz.quiz_id);

            const assignedId = assignment ? assignment.course_draft_quiz_id : null;
            const assignedModuleId = assignment ? assignment.module_id : null;
            const assignedSubmoduleId = assignment ? assignment.submodule_id : null;

            const btnClass = assignedId ? 'delete-btn btn-danger' : 'assign-btn btn-success';
            const btnText = assignedId ? 'Delete' : 'Assign';

            const row = $(`
                <tr data-quiz-id="${quiz.quiz_id}" ${assignedId ? `data-course-draft-quiz-id="${assignedId}"` : ''}>
                    <td>${index + 1}</td>
                    <td>${quiz.quiz_title}</td>
                    <td>
                        <select class="form-control form-select-sm module-dropdown">
                            <option value="">Select Module</option>
                            ${moduleOptionsHtml}
                        </select>
                    </td>
                    <td>
                        <select class="form-control form-select-sm submodule-dropdown">
                            <option value="">Select Submodule</option>
                        </select>
                    </td>
                    <td>
                        <button class="btn btn-sm ${btnClass}">${btnText}</button>
                    </td>
                </tr>
            `);

            tableBody.append(row);

            const moduleDropdown = row.find('.module-dropdown');
            const submoduleDropdown = row.find('.submodule-dropdown');

            // If an assignment exists for this quiz, pre-select values
            if (assignedModuleId) {
                moduleDropdown.val(assignedModuleId); // Set the selected module
                // Load and pre-select the submodules for the assigned module
                fetchSubmodules(assignedModuleId, submoduleDropdown, assignedSubmoduleId);
            } else {
                // If not assigned, ensure the submodule dropdown is initially disabled
                submoduleDropdown.prop('disabled', true);
            }
        });

    } catch (err) {
        console.error("Error fetching quiz data:", err);
        alert('Failed to load quiz data. Please try again: ' + err.message);
    } finally {
        $('#loader').hide();
    }
}

// --- Quiz Assignment/Deletion Logic (No changes needed here) ---

function assignQuiz(row, quizId) {
    const btn = row.find('button.assign-btn');
    btn.prop('disabled', true);

    const courseDraftId = getQueryParam('draft');
    const moduleId = row.find('.module-dropdown').val();
    const submoduleId = row.find('.submodule-dropdown').val();

    if (!moduleId || !submoduleId || !courseDraftId) {
        alert('Please select both a Module and a Submodule to assign the quiz.');
        btn.prop('disabled', false);
        return;
    }

    $.post('apis/add_course_draft_quiz.php', {
        course_draft_id: courseDraftId,
        module_id: moduleId,
        submodule_id: submoduleId,
        quiz_id: quizId
    }, function (response) {
        if (response.success && response.id) {
            row.attr('data-course-draft-quiz-id', response.id);
            row.data('course-draft-quiz-id', response.id);

            btn.text('Delete')
                .removeClass('assign-btn btn-success')
                .addClass('delete-btn btn-danger')
                .prop('disabled', false);

            alert('Quiz assigned successfully!');
        } else {
            alert('Failed to assign quiz: ' + (response.message || 'Unknown error'));
            btn.prop('disabled', false);
        }
    }, 'json').fail(() => {
        alert('Error occurred while assigning quiz.');
        btn.prop('disabled', false);
    });
}

function deleteQuizAssignment(courseDraftQuizId, row) {
    const btn = row.find('button.delete-btn');
    btn.prop('disabled', true);

    if (!confirm('Are you sure you want to remove this quiz assignment from the draft?')) {
        btn.prop('disabled', false);
        return;
    }

    $.post('apis/delete_course_draft_quiz.php', {
        course_draft_quiz_id: courseDraftQuizId
    }, function (response) {
        if (response.success) {
            row.removeAttr('data-course-draft-quiz-id');
            row.removeData('course-draft-quiz-id');

            btn.text('Assign')
                .removeClass('delete-btn btn-danger')
                .addClass('assign-btn btn-success')
                .prop('disabled', false);

            // Reset dropdowns to default state after deletion
            row.find('.module-dropdown').val('');
            row.find('.submodule-dropdown').empty().append(`<option value="">Select Submodule</option>`);
            row.find('.submodule-dropdown').prop('disabled', true); // Disable after deletion

            alert('Quiz assignment deleted!');
        } else {
            alert('Failed to delete quiz assignment: ' + (response.message || 'Unknown error'));
            btn.prop('disabled', false);
        }
    }, 'json').fail(() => {
        alert('Error occurred while deleting quiz assignment.');
        btn.prop('disabled', false);
    });
}

// --- Document Ready / Initialization ---

$(document).ready(function () {
    fetchQuizData(); // Initial load of quiz data and dropdowns

    // Event delegation for assign/delete buttons
    $('#quizDataGrid').on('click', 'button.assign-btn, button.delete-btn', function () {
        const btn = $(this);
        const row = btn.closest('tr');
        const quizId = row.data('quiz-id');

        if (btn.hasClass('assign-btn')) {
            assignQuiz(row, quizId);
        } else if (btn.hasClass('delete-btn')) {
            const courseDraftQuizId = row.data('course-draft-quiz-id');
            if (!courseDraftQuizId) {
                alert('No assignment found to delete.');
                return;
            }
            deleteQuizAssignment(courseDraftQuizId, row);
        }
    });

    // Event delegation for module dropdown change to load submodules
    $('#quizDataGrid').on('change', '.module-dropdown', function () {
        const row = $(this).closest('tr');
        const moduleId = $(this).val();
        const submoduleDropdown = row.find('.submodule-dropdown');
        
        // If a module is selected, enable and fetch submodules; otherwise, disable
        if (moduleId) {
            fetchSubmodules(moduleId, submoduleDropdown);
        } else {
            submoduleDropdown.empty().append(`<option value="">Select Submodule</option>`);
            submoduleDropdown.prop('disabled', true);
        }
    });
});
</script>

<!--for submodule-->
<script>
$(document).ready(function () {
    const draftId = $('input[name="draft_id"]').val();

    // Utility: Generate HTML for a blank submodule input row (always has a PLUS button initially)
    function getBlankSubmoduleHTML() {
        return `
            <div class="content-block row border p-3 mb-3" data-submodule-id="new">
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4">
                    <button type="button" class="btn btn-primary mb-25 mt-25 leftToggleSubmoduleBtn">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Modules</label>
                        <select class="form-control module-name-dropdown" name="module_name_id[]" style="width: 100%;" required>
                            </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Submodule Name <span class="text-danger">*</span></label>
                        <input class="form-control submodule-name-input" type="text" name="submodule_name[]" placeholder="Submodule Name" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Study Material Title <span class="text-danger">*</span></label>
                        <input class="form-control vid-title-input" type="text" name="vidtitlesub[]" placeholder="Study Material Title" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input class="form-control file-input" type="file" name="study_files_sub[]" accept="video/*,application/pdf,image/*" required>
                    </div>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-primary mt-25 btn-circle addMoreSubContent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                </div>
            </div>`;
    }

    // Utility: Generate HTML for an existing submodule or its content (read-only fields and MINUS buttons)
    // This function handles rendering existing main submodule blocks AND their associated study materials.
    function getExistingSubmoduleHTML(submoduleId, moduleNameId, submoduleName, moduleNameText, contentTitle = '', contentFileName = '', contentId = 'new') {
        const isMainSubmoduleRow = (contentTitle === '' && contentFileName === ''); // True if this HTML represents the main submodule row (not an extra content row)

        let leftButtonHtml = '';
        if (isMainSubmoduleRow) {
            // Main submodule row gets the remove button
            leftButtonHtml = `
                <button type="button" class="btn btn-danger mb-25 mt-25 removeSubmoduleBtn">
                    <i class="fas fa-minus"></i>
                </button>`;
        }
        // Extra content rows don't get a button in the first column, as deletion is per row using removeSubContent.

        return `
            <div class="${isMainSubmoduleRow ? 'content-block' : 'extra-content-row'} row border p-3 mb-3" data-submodule-id="${submoduleId}" ${isMainSubmoduleRow ? '' : `data-content-id="${contentId}"`}>
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4">
                    ${leftButtonHtml}
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Modules</label>
                        <select class="form-control module-name-dropdown" name="module_name_id[]" style="width: 100%;" disabled>
                            <option value="${moduleNameId || ''}" selected>${moduleNameText || 'Select Module'}</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Submodule Name <span class="text-danger">*</span></label>
                        <input class="form-control submodule-name-input" type="text" name="submodule_name[]" value="${submoduleName}" readonly>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Study Material Title <span class="text-danger">*</span></label>
                        <input class="form-control vid-title-input" type="text" name="vidtitlesub[]" value="${contentTitle}" ${isMainSubmoduleRow ? 'placeholder="Study Material Title"' : ''} ${contentTitle ? 'readonly' : ''} required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input class="form-control file-input" type="${contentFileName ? 'text' : 'file'}" value="${contentFileName}" ${contentFileName ? 'readonly' : ''} name="study_files_sub[]" ${contentFileName ? '' : 'accept="video/*,application/pdf,image/*"'} required>
                        ${contentFileName ? `<small class="form-text text-muted">Current: ${contentFileName}</small>` : ''}
                    </div>
                </div>
                <div class="col-md-1">
                    ${isMainSubmoduleRow ?
                        `<button type="button" class="btn btn-primary mt-25 btn-circle addMoreSubContent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>`
                        :
                        `<button type="button" class="btn btn-danger mt-25 btn-circle removeSubContent" style="border-radius: 50%"><i class="fas fa-minus"></i></button>`
                    }
                </div>
            </div>`;
    }

    // Load dynamic module options (populate module dropdowns)
    function loadModulesForDropdown($selectElement, selectedId = null) {
        $.ajax({
            url: 'apis/get_modules_by_draft.php',
            type: 'GET',
            data: { draft_id: draftId },
            dataType: 'json',
            success: function (res) {
                if (res.success && Array.isArray(res.modules)) {
                    $selectElement.empty().append(`<option value="">Select Module</option>`);
                    res.modules.forEach(mod => {
                        const isSelected = (selectedId !== null && selectedId == mod.module_id) ? 'selected' : '';
                        $selectElement.append(`<option value="${mod.module_id}" ${isSelected}>${mod.module_name}</option>`);
                    });
                } else {
                    console.warn("Failed to load modules for dropdown or no modules found.");
                    $selectElement.empty().append(`<option value="">No Modules Available</option>`);
                }

                // Re-initialize Select2
                // Destroying and re-initializing Select2 is important if elements are added dynamically
                if ($selectElement.hasClass('select2-hidden-accessible')) {
                    $selectElement.select2('destroy');
                }
                $selectElement.select2({
                    placeholder: "Select Module",
                    allowClear: true
                });

                // Apply disabled state for Select2 (visual only for existing rows)
                // Select2 creates its own HTML, so you need to target its container for visual disabled state
                if ($selectElement.prop('disabled')) {
                     $selectElement.next('.select2-container').find('.select2-selection').css('background-color', '#e9ecef');
                } else {
                    $selectElement.next('.select2-container').find('.select2-selection').css('background-color', '');
                }

            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (get_modules_by_draft.php):", textStatus, errorThrown, jqXHR.responseText);
                $selectElement.empty().append(`<option value="">Error Loading Modules</option>`);
                if ($selectElement.hasClass('select2-hidden-accessible')) {
                    $selectElement.select2('destroy');
                }
                $selectElement.select2(); // Initialize it even on error
            }
        });
    }

    // Function to ensure a blank submodule is always present at the end of the contentWrapperSubModule
    function ensureBlankSubmoduleAtEnd() {
        const $lastBlock = $('#contentWrapperSubModule .content-block').last();
        const isLastBlockTrulyBlank = $lastBlock.length > 0 &&
                                       $lastBlock.data('submodule-id') === 'new' &&
                                       $lastBlock.find('input.submodule-name-input').val() === '' &&
                                       $lastBlock.find('input.vid-title-input').val() === '' &&
                                       $lastBlock.find('input.file-input').get(0).files.length === 0;


        if (!isLastBlockTrulyBlank) {
            console.log("Adding new blank submodule row.");
            const $newBlankRow = $(getBlankSubmoduleHTML());
            $('#contentWrapperSubModule').append($newBlankRow);
            loadModulesForDropdown($newBlankRow.find('.module-name-dropdown'));
        } else {
            console.log("Last block is already a truly blank submodule row. No new row added.");
        }
    }

    // Function to update the left button of a "new" submodule block to a "minus" button
    function convertNewSubmoduleToRemovable($submoduleBlock) {
        $submoduleBlock.find('.leftToggleSubmoduleBtn')
            .removeClass('btn-primary leftToggleSubmoduleBtn') // Remove old class
            .addClass('btn-danger removeSubmoduleBtn')      // Add new class
            .find('i')
            .removeClass('fa-plus')
            .addClass('fa-minus');
        console.log("Converted left button to removable for submodule ID:", $submoduleBlock.data('submodule-id'));
    }

    // --- Initial Loading Logic ---
    if (draftId) {
        $.ajax({
            url: 'apis/get_submodules_by_draft.php',
            type: 'GET',
            data: { draft_id: draftId },
            dataType: 'json',
            success: function (res) {
                $('#contentWrapperSubModule').empty(); // Clear existing content
                console.log("Submodules loaded:", res);

                if (res.success && Array.isArray(res.submodules) && res.submodules.length > 0) {
                    res.submodules.forEach(submodule => {
                        const submoduleId = submodule.submodule_id;

                        // Add the main submodule row (which will have the minus button)
                        const $submoduleBlock = $(getExistingSubmoduleHTML(submoduleId, submodule.module_id, submodule.submodule_name, submodule.module_name));
                        $('#contentWrapperSubModule').append($submoduleBlock);
                        console.log("Appended main submodule block:", submodule.submodule_name, "ID:", submoduleId);

                        // Populate the module dropdown for this row and set its value
                        loadModulesForDropdown($submoduleBlock.find('.module-name-dropdown'), submodule.module_id);

                        // Append existing study materials as read-only rows below the main submodule block
                        if (submodule.contents && submodule.contents.length > 0) {
                            submodule.contents.forEach(content => {
                                const contentId = content.study_material_id;
                                const $contentRow = $(getExistingSubmoduleHTML(submoduleId, submodule.module_id, submodule.submodule_name, submodule.module_name, content.title, content.actual_file_name, contentId));
                                $submoduleBlock.after($contentRow); // Insert after the current main submodule block
                                console.log("Appended content row:", content.title, "for submodule:", submodule.submodule_name);
                            });
                        }
                    });
                }
                ensureBlankSubmoduleAtEnd(); // Always ensure one blank row at the end
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (get_submodules_by_draft.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Failed to fetch existing submodules.');
                $('#contentWrapperSubModule').empty(); // Clear if error, then add a fresh blank row
                ensureBlankSubmoduleAtEnd(); // Fallback to adding a blank row if fetch fails
            }
        });
    } else {
        // If no draftId, just add a single blank submodule row on initial load
        console.log("No draftId found, adding initial blank submodule row.");
        ensureBlankSubmoduleAtEnd();
    }

    // --- Event Handlers ---

    // Event handler for left button (for adding new blank submodules)
    $(document).on('click', '.leftToggleSubmoduleBtn', function () {
        const $currentSubmoduleBlock = $(this).closest('.content-block');
        console.log("Clicked leftToggleSubmoduleBtn on:", $currentSubmoduleBlock);

        // Convert the current block's left button from '+' to '-'
        convertNewSubmoduleToRemovable($currentSubmoduleBlock);

        // Append a brand new blank submodule row after the current one
        const $newBlankRow = $(getBlankSubmoduleHTML());
        $currentSubmoduleBlock.after($newBlankRow);
        loadModulesForDropdown($newBlankRow.find('.module-name-dropdown'));
        console.log("Added new blank row after current block.");

        // Ensure the very last block always has a '+' if it's truly blank
        ensureBlankSubmoduleAtEnd();
    });

    // Remove submodule row (left side - for existing submodules/saved submodules, or new blank ones)
    $(document).on('click', '.removeSubmoduleBtn', function () {
        const $submoduleBlock = $(this).closest('.content-block');
        const submoduleId = $submoduleBlock.data('submodule-id');
        const submoduleName = $submoduleBlock.find('input.submodule-name-input').val();
        console.log("Clicked removeSubmoduleBtn for submodule ID:", submoduleId, "Name:", submoduleName);

        // Check if it's a new unsaved row (either data-submodule-id is 'new' or submodule name is effectively blank)
        if (submoduleId === 'new' || submoduleName.trim() === '') {
            if (confirm("Are you sure you want to delete this blank submodule row?")) {
                $submoduleBlock.remove();
                console.log("Removed unsaved blank submodule row.");
                ensureBlankSubmoduleAtEnd(); // Ensure a blank module is still at the end
            }
            return;
        }

        // If it has a real ID, it's an existing/saved submodule
        if (!confirm("Are you sure you want to delete this entire submodule and all its contents? This action cannot be undone.")) return;

        // Ajax call to delete submodule from DB
        $.ajax({
            url: 'apis/delete_draft_submodule_api.php',
            type: 'POST',
            data: { submodule_id: submoduleId, submodule_name: submoduleName },
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $submoduleBlock.remove();
                    // Also remove any associated content rows that might be orphaned in the DOM
                    $(`div.extra-content-row[data-submodule-id="${submoduleId}"]`).remove();
                    alert('Submodule deleted successfully.');
                    console.log("Submodule deleted successfully:", submoduleId);
                    ensureBlankSubmoduleAtEnd(); // Always ensure a blank submodule at the end
                } else {
                    alert('Failed to delete submodule: ' + (res.message || 'Unknown error'));
                    console.error('Failed to delete submodule:', res.message);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (delete_draft_submodule_api.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Error deleting submodule: ' + textStatus);
            }
        });
    });

    // Remove content row (right side - button for individual study materials)
    $(document).on('click', '.removeSubContent', function () {
        if (!confirm("Are you sure you want to delete this study material from the submodule?")) return;

        const $contentRow = $(this).closest('.extra-content-row');
        const contentId = $contentRow.data('content-id');
        const submoduleId = $contentRow.data('submodule-id');
        console.log("Clicked removeSubContent for content ID:", contentId, "submodule ID:", submoduleId);


        // Ajax call to delete content from DB
        $.ajax({
            url: 'apis/delete_draft_submodule_content_api.php',
            type: 'POST',
            data: { content_id: contentId, submodule_id: submoduleId },
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $contentRow.remove();
                    alert('Submodule study material deleted successfully.');
                    console.log("Submodule study material deleted successfully:", contentId);
                } else {
                    alert('Failed to delete study material: ' + (res.message || 'Unknown error'));
                    console.error('Failed to delete study material:', res.message);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (delete_draft_submodule_content_api.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Error deleting study material: ' + textStatus);
            }
        });
    });

    // Add more content (main upload and logic for handling the current row)
    $(document).on('click', '.addMoreSubContent', function () {
        const $btn = $(this);
        const $block = $btn.closest('.content-block'); // This is the main submodule block
        const moduleDropdown = $block.find('.module-name-dropdown');
        const moduleId = moduleDropdown.val();
        const moduleNameText = moduleDropdown.find('option:selected').text(); // Get the selected module name text
        const submoduleNameInput = $block.find('input.submodule-name-input');
        const submoduleName = submoduleNameInput.val();
        const vidTitleInput = $block.find('input[name="vidtitlesub[]"]');
        const vidTitle = vidTitleInput.val();
        const fileInput = $block.find('input[type="file"]')[0];
        const file = fileInput.files[0];
        const draftId = $('input[name="draft_id"]').val();

        console.log("Attempting to add more submodule content:");
        console.log("Module ID:", moduleId);
        console.log("Submodule Name:", submoduleName);
        console.log("Video Title:", vidTitle);
        console.log("File:", file ? file.name : "No file selected");
        console.log("Draft ID:", draftId);

        if (!moduleId || !submoduleName || !vidTitle || !file) {
            alert("Please fill all required fields (Module, Submodule Name, Study Material Title, and Upload File) before adding content.");
            console.warn("Validation failed: Missing required fields.");
            return;
        }

        // Show a loading indicator and disable the button/inputs to prevent multiple clicks
        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Adding...');
        moduleDropdown.prop('disabled', true).trigger('change'); // Disable Select2 dropdown
        submoduleNameInput.prop('readonly', true);
        vidTitleInput.prop('readonly', true);
        if (fileInput) $(fileInput).prop('disabled', true); // Use jQuery to disable file input

        const formData = new FormData();
        formData.append('module_id', moduleId);
        formData.append('submodule_name', submoduleName);
        formData.append('vidtitlesub', vidTitle);
        formData.append('study_files_sub', file); // Append the actual file object
        formData.append('draft_id', draftId);

        let currentSubmoduleId = $block.data('submodule-id');
        if (currentSubmoduleId !== 'new') {
            formData.append('submodule_id', currentSubmoduleId);
            console.log("Existing submodule ID being sent:", currentSubmoduleId);
        } else {
            console.log("New submodule, no ID being sent initially.");
        }

        $.ajax({
            url: 'apis/add_submodule_content_api.php',
            type: 'POST',
            data: formData,
            processData: false, // Important for FormData
            contentType: false, // Important for FormData
            dataType: 'json',
            success: function (res) {
                console.log("AJAX success response:", res);
                $btn.prop('disabled', false).html('<i class="fas fa-plus"></i>'); // Re-enable plus button

                if (res.success) {
                    alert('Submodule content uploaded successfully.');
                    const newContentId = res.content_id;
                    const returnedSubmoduleId = res.submodule_id; // The ID returned by the server for the submodule
                    console.log("New Content ID:", newContentId, "Returned Submodule ID:", returnedSubmoduleId);

                    if (currentSubmoduleId === 'new') {
                        $block.data('submodule-id', returnedSubmoduleId); // Update the data-submodule-id for the block
                        convertNewSubmoduleToRemovable($block); // Change the left button
                        console.log("Submodule ID updated to:", returnedSubmoduleId);
                    }

                    // Create the readonly row for the newly added content and append it
                    const readonlyContentRow = $(getExistingSubmoduleHTML(returnedSubmoduleId, moduleId, submoduleName, moduleNameText, vidTitle, file.name, newContentId));
                    $block.after(readonlyContentRow); // Append right after the current main submodule block
                    console.log("Appended new readonly content row.");

                    // Clear the content-specific input fields for the current block
                    vidTitleInput.val('');
                    vidTitleInput.prop('readonly', false);
                    if (fileInput) { // Check if fileInput exists before accessing its properties
                        $(fileInput).val(''); // Clear the file input
                        $(fileInput).prop('disabled', false); // Re-enable the file input
                    }
                    console.log("Cleared input fields for next content upload.");

                    // Ensure a blank submodule is always available at the very end for new entries
                    ensureBlankSubmoduleAtEnd();

                } else {
                    alert('Upload failed: ' + (res.message || 'Unknown error'));
                    console.error('Upload failed with message:', res.message);
                    // Re-enable inputs on failure
                    if (currentSubmoduleId === 'new') {
                        moduleDropdown.prop('disabled', false).trigger('change');
                        submoduleNameInput.prop('readonly', false);
                    }
                    vidTitleInput.prop('readonly', false);
                    if (fileInput) $(fileInput).prop('disabled', false);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("AJAX Error (add_submodule_content_api.php):", textStatus, errorThrown, jqXHR.responseText);
                alert('Upload failed: ' + textStatus + (errorThrown ? ' - ' + errorThrown : '') + '. Please try again. Response: ' + jqXHR.responseText);

                // Re-enable inputs on error
                $btn.prop('disabled', false).html('<i class="fas fa-plus"></i>');
                const currentSubmoduleId = $block.data('submodule-id');
                if (currentSubmoduleId === 'new') {
                    moduleDropdown.prop('disabled', false).trigger('change');
                    submoduleNameInput.prop('readonly', false);
                }
                vidTitleInput.prop('readonly', false);
                if (fileInput) $(fileInput).prop('disabled', false);
            }
        });
    });
});
</script>

<!--table module popup-->
<script>
    // Utility function to get query parameters (ensure this is defined once in your script)
function getQueryParam(param) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}

$(document).ready(function() {
    const draftId = getQueryParam('draft');

    // Event listener for when the modal is fully shown
    // This ensures modules are fetched only when the user opens the modal
    $('#selectModuleModal').on('shown.bs.modal', function () {
        if (!draftId) {
            alert('Draft ID is missing. Cannot fetch modules.');
            // Optionally close the modal if no draft ID is present
            $(this).modal('hide');
            return;
        }
        fetchAndDisplayModulesInModal(); // Call function to fetch and display modules
    });

    // Function to fetch all modules and populate the modal table
    function fetchAndDisplayModulesInModal() {
        const modalTableBody = $('#modulesTableInModal tbody');
        const modalLoader = $('#modalModuleLoader');

        modalTableBody.empty(); // Clear previous content
        modalLoader.show(); // Show loading spinner
        $('#selectAllModules').prop('checked', false); // Uncheck "Select All" checkbox

        $.ajax({
            url: 'apis/module_api.php', // API endpoint to get all modules
            method: 'GET',
            dataType: 'json',
            success: function(response) {
            modalLoader.hide(); // Hide loading spinner
        
            if (Array.isArray(response)) {
                if (response.length === 0) {
                    modalTableBody.append('<tr><td colspan="2" class="text-center">No modules found.</td></tr>');
                    return;
                }
        
                response.forEach(module => {
                    modalTableBody.append(`
                        <tr>
                            <td><input type="checkbox" class="module-select-checkbox" value="${module.module_id}"></td>
                            <td>${module.module_name}</td>
                        </tr>
                    `);
                });
            } else {
                modalTableBody.append('<tr><td colspan="2" class="text-center">Error loading modules: Unexpected response format</td></tr>');
                console.warn("API returned unexpected format (not an array):", response);
            }
        }
,
            error: function(jqXHR, textStatus, errorThrown) {
                modalLoader.hide(); // Hide loading spinner
                console.error("Error fetching modules for modal:", textStatus, errorThrown, jqXHR.responseText);
                modalTableBody.append('<tr><td colspan="2" class="text-center">Failed to load modules. Please check console for details.</td></tr>');
            }
        });
    }

    // Event listener for the "Select All" checkbox in the modal
    $('#selectAllModules').on('change', function() {
        $('.module-select-checkbox').prop('checked', $(this).prop('checked'));
    });

    // Event listener for the "Add Selected Modules" button in the modal footer
    $('#addSelectedModulesBtn').on('click', function() {
        const selectedModuleIds = [];
        $('.module-select-checkbox:checked').each(function() {
            selectedModuleIds.push($(this).val());
        });

        if (selectedModuleIds.length === 0) {
            alert('Please select at least one module to add.');
            return;
        }

        if (!draftId) {
            alert('Draft ID is missing. Cannot add modules to draft.');
            return;
        }

        const btn = $(this);
        const originalBtnText = btn.text();
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Adding...'); // Show loading feedback

        $.ajax({
            url: 'apis/add_course_draft_modules.php', // API endpoint to save modules to draft
            method: 'POST',
            dataType: 'json',
            data: {
                draft_id: draftId,
                module_ids: selectedModuleIds // Send an array of selected module IDs
            },
            success: function(response) {
                btn.prop('disabled', false).text(originalBtnText); // Restore button state
                if (response.success) {
                    alert('Selected module(s) added to draft successfully! ' + (response.message || ''));
                    $('#selectModuleModal').modal('hide'); // Close the modal
                    // It's highly recommended to refresh the main #dataGrid table on tab_2
                    // to show the newly added modules without a full page reload.
                    // For now, a simple page reload will suffice, but consider a dedicated function.
                    location.reload();
                } else {
                    alert('Failed to add module(s) to draft: ' + (response.message || 'Unknown error.'));
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                btn.prop('disabled', false).text(originalBtnText); // Restore button state
                console.error("Error adding modules to draft:", textStatus, errorThrown, jqXHR.responseText);
                alert("An error occurred while trying to add modules. Please try again.");
            }
        });
    });
});
</script>


<!--table submodule popup-->
<script>
$(document).ready(function() {
    const draftId = getQueryParam('draft');

    // Event listener for when the submodule modal is fully shown
    $('#selectSubmoduleModal').on('shown.bs.modal', function() {
        if (!draftId) {
            alert('Draft ID is missing. Cannot fetch modules.');
            $(this).modal('hide');
            return;
        }
        populateParentModuleDropdown(); // First populate the parent module dropdown
    });

    // Function to populate parent module dropdown in modal
    function populateParentModuleDropdown() {
        const dropdown = $('#modalParentModuleSelect');
        dropdown.empty().append('<option value="">Select a Parent Module</option>');
        
        $.ajax({
            url: 'apis/module_api.php',
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                if (Array.isArray(response)) {
                    response.forEach(module => {
                        dropdown.append(`<option value="${module.module_id}">${module.module_name}</option>`);
                    });
                } else {
                    console.warn("Unexpected response format for modules:", response);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error("Error fetching modules for dropdown:", textStatus, errorThrown);
            }
        });
    }

    // Event listener for parent module selection change
    $('#modalParentModuleSelect').on('change', function() {
        const moduleId = $(this).val();
        if (!moduleId) {
            $('#submodulesTableInModal tbody').html('<tr><td colspan="2" class="text-center">Select a parent module above to load submodules.</td></tr>');
            return;
        }
        fetchSubmodulesForModule(moduleId);
    });

    // Function to fetch submodules for a selected module
    function fetchSubmodulesForModule(moduleId) {
        const modalTableBody = $('#submodulesTableInModal tbody');
        const modalLoader = $('#modalSubmoduleLoader');

        modalTableBody.empty();
        modalLoader.show();
        $('#selectAllSubmodules').prop('checked', false);

        $.ajax({
            url: 'apis/submodule_selected_api.php',
            method: 'GET',
            data: { module_id: moduleId },
            dataType: 'json',
            success: function(response) {
                modalLoader.hide();
                
                if (Array.isArray(response)) {
                    if (response.length === 0) {
                        modalTableBody.append('<tr><td colspan="2" class="text-center">No submodules found for this module.</td></tr>');
                        return;
                    }

                    response.forEach(submodule => {
                        modalTableBody.append(`
                            <tr>
                                <td><input type="checkbox" class="submodule-select-checkbox" 
                                    data-module-id="${submodule.module_id}" 
                                    value="${submodule.submodule_id}"></td>
                                <td>${submodule.submodule_name}</td>
                            </tr>
                        `);
                    });
                } else {
                    modalTableBody.append('<tr><td colspan="2" class="text-center">Error loading submodules: Unexpected response format</td></tr>');
                    console.warn("API returned unexpected format (not an array):", response);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                modalLoader.hide();
                console.error("Error fetching submodules:", textStatus, errorThrown);
                modalTableBody.append('<tr><td colspan="2" class="text-center">Failed to load submodules. Please try again.</td></tr>');
            }
        });
    }

    // Event listener for "Select All" checkbox in submodule modal
    $('#selectAllSubmodules').on('change', function() {
        $('.submodule-select-checkbox').prop('checked', $(this).prop('checked'));
    });

    // Event listener for "Add Selected Submodules" button
    $('#addSelectedSubmodulesBtn').on('click', function() {
        const selectedSubmodules = [];
        const moduleId = $('#modalParentModuleSelect').val(); // Get the selected module ID
        
        if (!moduleId) {
            alert('Please select a parent module first.');
            return;
        }

        $('.submodule-select-checkbox:checked').each(function() {
            selectedSubmodules.push({
                submodule_id: $(this).val(),
                module_id: moduleId // Use the parent module ID from dropdown
            });
        });

        if (selectedSubmodules.length === 0) {
            alert('Please select at least one submodule to add.');
            return;
        }

        if (!draftId) {
            alert('Draft ID is missing. Cannot add submodules to draft.');
            return;
        }

        const btn = $(this);
        const originalBtnText = btn.text();
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Adding...');

        $.ajax({
            url: 'apis/add_course_draft_submodules.php',
            method: 'POST',
            dataType: 'json',
            data: {
                draft_id: draftId,
                module_id: moduleId, // Pass the parent module ID separately
                submodules: selectedSubmodules
            },
            success: function(response) {
                btn.prop('disabled', false).text(originalBtnText);
                if (response.success) {
                    alert('Selected submodule(s) added to draft successfully!');
                    $('#selectSubmoduleModal').modal('hide');
                    // Refresh the submodule content or reload the page
                    location.reload();
                } else {
                    alert('Failed to add submodule(s): ' + (response.message || 'Unknown error'));
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                btn.prop('disabled', false).text(originalBtnText);
                console.error("Error adding submodules:", textStatus, errorThrown);
                alert("An error occurred while adding submodules. Please try again.");
            }
        });
    });

    // [Rest of your existing code remains the same...]
    // Populate module dropdown in the main form
    function populateModuleDropdown() {
        const dropdown = $('.module-name-dropdown');
        dropdown.empty().append('<option value="">Select a Module</option>');
        
        $.ajax({
            url: 'apis/module_api.php',
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                if (Array.isArray(response)) {
                    response.forEach(module => {
                        dropdown.append(`<option value="${module.module_id}">${module.module_name}</option>`);
                    });
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error("Error fetching modules:", textStatus, errorThrown);
            }
        });
    }

    // Initialize module dropdown when tab is shown
    $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
        if ($(e.target).attr('href') === '#tab_3') {
            populateModuleDropdown();
        }
    });

    // Add more submodule content blocks
    $(document).on('click', '.addMoreSubContent', function() {
        const contentBlock = $(this).closest('.content-block');
        const newBlock = contentBlock.clone();
        newBlock.find('input').val('');
        newBlock.find('select').val('').trigger('change');
        contentBlock.after(newBlock);
    });

    // Add more submodule rows
    $('#addMoreSubModule').on('click', function() {
        const newRow = $('#contentWrapperSubModule .content-block:first').clone();
        newRow.find('input').val('');
        newRow.find('select').val('').trigger('change');
        $('#contentWrapperSubModule').append(newRow);
    });

    // Tab navigation
    $('#goToTab4').on('click', function() {
        $('.nav-tabs a[href="#tab_4"]').tab('show');
    });

    $('#goToTab02').on('click', function() {
        $('.nav-tabs a[href="#tab_2"]').tab('show');
    });
});
</script>




<script>
    $(document).ready(function() {
    // Initialize select2 for category and proposed_course if you are using it
    // Example:
    $('#category').select2();
    $('#proposed_courses').select2(); // Initialize proposed_course as well

    $('#category').on('change', function() {
        var selectedCategoryId = $(this).val(); // Get the selected category ID

        // Clear existing options in Proposed Courses
        $('#proposed_course').empty();

        // If a category is selected (not an empty option, if you have one)
        if (selectedCategoryId) {
            $.ajax({
                url: 'fetch_proposed_courses.php', // Your server-side script to fetch courses
                method: 'GET', // Or POST, depending on your preference
                data: { category_id: selectedCategoryId },
                dataType: 'json', // Expect JSON response
                success: function(data) {
                    // Populate the Proposed Courses dropdown
                    $.each(data, function(index, course) {
                        $('#proposed_course').append($('<option>', {
                            value: course.id,
                            text: course.title
                        }));
                    });
                    // Trigger select2 update if you are using it and added options dynamically
                    $('#proposed_course').trigger('change');
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching proposed courses:", status, error);
                    // Optionally, display an error message to the user
                }
            });
        }
    });
});
</script>


<script>
    $(document).ready(function() {

    // Listen for changes on the 'category' dropdown
    $('#category').on('change', function() {
        var selectedCategoryId = $(this).val(); // Get the ID of the selected category

        // --- NEW: Get the current draft ID from the hidden input field ---
        var currentDraftId = $('input[name="draft_id"]').val();

        // Clear any existing options in the 'proposed_course' dropdown
        $('#proposed_courses').empty().trigger('change');

        // Only proceed if a category is actually selected (not the "Select Category" option)
        if (selectedCategoryId) {
            $.ajax({
                url: 'apis/fetch_proposed_courses.php', // Your server-side script
                method: 'GET',
                data: {
                    category_id: selectedCategoryId,
                    current_draft_id: currentDraftId // --- NEW: Pass the current draft ID ---
                },
                dataType: 'json', // Expect JSON data back
                success: function(data) {
                    // Add a default "Select Proposed Course" option (optional)
                    // $('#proposed_courses').append($('<option>', {
                    //     value: '',
                    //     text: 'Select Proposed Course'
                    // }));

                    // Check if the API call was successful and contains courses array
                    if (data.success && data.courses && Array.isArray(data.courses) && data.courses.length > 0) {
                        // Loop through the received data.courses array
                        $.each(data.courses, function(index, course) {
                            $('#proposed_courses').append($('<option>', {
                                value: course.id,
                                text: course.text
                            }));
                        });
                    } else {
                        console.log("No proposed courses found for this category or API call failed or courses array is empty/invalid.", data);
                    }

                    // Trigger Select2 to update its display after adding new options
                    $('#proposed_courses').trigger('change');
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching proposed courses:", status, error);
                    $('#proposed_courses').append($('<option>', {
                        value: '',
                        text: 'Error loading courses'
                    }));
                    $('#proposed_courses').trigger('change');
                }
            });
        } else {
            // If no category is selected, add the default option back
            $('#proposed_courses').append($('<option>', {
                value: '',
                text: 'Select Proposed Course'
            }));
            $('#proposed_courses').trigger('change');
        }
    });
});
</script>


</body>
</html>
