
<?php 
$page_name = 'Add Mentor';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD MENTOR
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="mentor_master.php">Mentor</a></li>
        <li class="active">Add mentor</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="mentorForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Mentor Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="mentor_name" name="mentor_name" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone No.<span class="text-danger">*</span></label>
                                <input class="form-control" type="tel" pattern="\d{10}" maxlength="10" minlength="10" autocomplete="off"  id="phone_no" name="phone_no" title="Please enter exactly 10 digits (numbers only)" required>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email ID<span class="text-danger">*</span></label>
                                <input class="form-control" type="email" autocomplete="off" id="email_id" name="email_id" pattern=".+\..{2,4}$" 
                              title="Please enter a valid email address" required>
                            </div>
                        </div>  
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Specialization<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="specialization" name="specialization" required>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>LinkedIn Profile</label>
                                <input class="form-control" type="url" autocomplete="off" id="linkedin_profile" name="linkedin_profile">
                            </div>
                        </div>                         
                        
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Mentor Image (Optional)</label>
                                <input class="form-control" type="file" autocomplete="off" id="mentor_img" name="mentor_img" accept="image/png, image/gif, image/jpeg">
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>CV (Optional)</label>
                                <input class="form-control" type="file" autocomplete="off" id="mentor_cv" name="mentor_cv" accept=".pdf">
                            </div>
                        </div>
                       
                        
                        <div class="col-md-4">
                <div class="form-group">
                  <div class="radio">
                  	  <input name="block_mentor" value="0" type="radio" id="Option_2" class="with-gap radio-col-red" checked="">
					  <label for="Option_2">Active</label>                    
                  </div>
                  <div class="radio">
                  	  <input name="block_mentor" value="1" type="radio" id="Option_1" class="with-gap radio-col-red">
					  <label for="Option_1">Inactive</label>   
                  </div>
                </div>
                        </div>    
                        

                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                  	  <input type="checkbox" id="industry_expert" value="1">
					  <label for="industry_expert">Industry Expert</label>
					  </div>
                            </div>
                        </div> 
                        

                    </div>
                    
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <a href="mentor_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$('#mentorForm').on('submit', function(event) {
    event.preventDefault();

    var formData = new FormData();

    formData.append('mentor_name', $('#mentor_name').val());
    formData.append('phone_no', $('#phone_no').val());
    formData.append('email_id', $('#email_id').val());
    formData.append('specialization', $('#specialization').val());
    formData.append('linkedin_profile', $('#linkedin_profile').val());
    formData.append('block_mentor', $('input[name="block_mentor"]:checked').val());
    formData.append('industry_expert', $('#industry_expert').is(':checked') ? '1' : '0');

    

    var mentorImg = $('#mentor_img')[0].files[0];
    var mentorCV = $('#mentor_cv')[0].files[0];

    if (mentorImg) {
        if (mentorImg.size > 1048576) {
            // If file size is more than 1MB, show an error message
            showAlert('File size exceeds the 1MB limit.', 'danger');
            return;
        } else {
            formData.append('mentor_img', mentorImg);
        }
    }
    
    if (mentorCV) {
        if (mentorCV.size > 1048576) {
            // If file size is more than 1MB, show an error message
            showAlert('File size exceeds the 1MB limit.', 'danger');
            return;
        } else {
            formData.append('mentor_cv', mentorCV);
        }
    }    

    $.ajax({
        url: 'apis/add_mentor_api.php',
        method: 'POST',
        data: formData,
        processData: false, 
        contentType: false,
        success: function(data) {
            if (data.status === 'success') {
                showAlert(data.message, 'success');
                $('#mentorForm')[0].reset();
            } else {
                showAlert(data.message, 'danger');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            showAlert('An error occurred while submitting the form.', 'danger');
        }
    });
});

</script>

</body>
</html>