<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

// Check if the request has required POST fields
if (isset($_POST['course_name']) && isset($_POST['course_category']) && isset($_POST['level'])) {

    $courseName = trim($_POST['course_name']);
    $courseCategory = trim($_POST['course_category']);
    $level = trim($_POST['level']);
    echo $hours = trim($_POST['hours']);
    $description = isset($_POST['description']) ? trim($_POST['description']) : '';

    $encryptedFileName = '';

    // Handle image upload
    if (isset($_FILES['course_img']) && $_FILES['course_img']['error'] === UPLOAD_ERR_OK) {
        $courseImg = $_FILES['course_img'];
        $fileName = $courseImg['name'];
        $fileTmpPath = $courseImg['tmp_name'];
        $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $encryptedFileName = hash('sha256', uniqid('', true)) . '.' . $fileExt;

        // Get folder name from DB
        $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
        $stmt->execute([':institute_id' => $institute_id]);
        $folderName = $stmt->fetchColumn();

        if (!$folderName) {
            echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
            exit();
        }

        $uploadDir = '../institutes/' . $folderName . '/course_images/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        $destPath = $uploadDir . $encryptedFileName;

        if (!move_uploaded_file($fileTmpPath, $destPath)) {
            echo json_encode(["status" => "error", "message" => "Error uploading the image."]);
            exit();
        }
    }

    try {
        // Check for existing course name
        $checkSql = "SELECT COUNT(*) FROM course_master WHERE course_name = :course_name";
        $checkStmt = $pdo->prepare($checkSql);
        $checkStmt->bindParam(':course_name', $courseName);
        $checkStmt->execute();

        if ($checkStmt->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Course name already exists."]);
            exit();
        }

        // Insert course into DB
        $sql = "INSERT INTO course_master (course_name, course_category, level, hours, description, created_by, institute_id, course_img)
                VALUES (:course_name, :course_category, :level, :hours, :description, :user_id, :institute_id, :course_img)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':course_name', $courseName);
        $stmt->bindParam(':course_category', $courseCategory);
        $stmt->bindParam(':level', $level);
        $stmt->bindParam(':hours', $hours);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':course_img', $encryptedFileName);
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':institute_id', $institute_id);
        $stmt->execute();

        echo json_encode(["status" => "success", "message" => "Course added successfully!"]);
    } catch (PDOException $e) {
        echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
    }

} else {
    echo json_encode(["status" => "error", "message" => "All fields are required."]);
}
?>