<?php
header('Content-Type: application/json');
require_once('../includes/connection.php'); // Adjust this path

$courseDraftId = isset($_POST['course_draft_id']) ? intval($_POST['course_draft_id']) : 0;
$moduleId = isset($_POST['module_id']) ? intval($_POST['module_id']) : 0;
$submoduleId = isset($_POST['submodule_id']) ? intval($_POST['submodule_id']) : 0;
$quizId = isset($_POST['quiz_id']) ? intval($_POST['quiz_id']) : 0;

if (!$courseDraftId || !$moduleId || !$submoduleId || !$quizId) {
    echo json_encode(['success' => false, 'message' => 'Invalid input data']);
    exit;
}

try {
    $sql = "INSERT INTO course_draft_quiz (course_draft_id, module_id, submodule_id, quiz_id, created_date)
            VALUES (:course_draft_id, :module_id, :submodule_id, :quiz_id, NOW())";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':course_draft_id' => $courseDraftId,
        ':module_id' => $moduleId,
        ':submodule_id' => $submoduleId,
        ':quiz_id' => $quizId,
    ]);

    // Get last inserted ID
    $lastId = $pdo->lastInsertId();

    echo json_encode(['success' => true, 'id' => $lastId]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
