<?php
require_once('../cr/vimeo_upload.php');
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

if (isset($_FILES['study_content']) && $_FILES['study_content']['error'] === UPLOAD_ERR_OK) {
    try {
    $title = trim($_POST['study_title']);
    $desc = $_POST['description'];
    $course_category = $_POST['category'];
    $block_content = $_POST['block_content'];
    $file = $_FILES['study_content'] ?? null;
    $fileTmp = $_FILES['study_content']['tmp_name'];
    $fileType = mime_content_type($fileTmp);
    
        if (!$title || !$file || !$course_category) {
            echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
            exit;
        }
        
        // Duplicate title check within the same category
        $checkStmt = $pdo->prepare("
            SELECT COUNT(*) FROM study_material 
            WHERE title = :title AND category_id = :category_id AND institute_id = :institute_id
        ");
        $checkStmt->execute([
            ':title' => $title,
            ':category_id' => $course_category,
            ':institute_id' => $institute_id
        ]);
        $exists = $checkStmt->fetchColumn();

        if ($exists > 0) {
            echo json_encode(['status' => 'error', 'message' => 'Study material already exists in the selected category.']);
            exit;
        }        
        
        $isVideo = strpos($fileType, 'video/') === 0;

        $vimeo_link = '';
        $video_id = '';
        $actual_file_name = $file['name'];
        $original_file_name = $file['name']; 
        $doc_type = 'file'; // default

        if ($isVideo) {
            // Upload video to Vimeo
            $uploadResult = uploadStudyMaterial($file, $title, '');
            if (!$uploadResult || !$uploadResult['success']) {
                echo json_encode([
                    'status' => 'error',
                    'message' => $uploadResult['message'] ?? 'Vimeo upload failed'
                ]);
                exit;
            }

            $vimeo_link = $uploadResult['video_link'];
            $video_id = $uploadResult['video_id'] ?? '';
            $doc_type = 'video';

        } else {
            // Validate file extension
            $allowedExts = ['pdf', 'jpg', 'jpeg', 'png', 'ppt', 'pptx', 'txt'];
            $fileExt = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            if (!in_array($fileExt, $allowedExts)) {
                echo json_encode(['status' => 'error', 'message' => 'Unsupported file type.']);
                exit;
            }

            // Get folder_name from institute_master
            $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
            $stmt->execute([':institute_id' => $institute_id]);
            $folderName = $stmt->fetchColumn();

            if (!$folderName) {
                echo json_encode(['status' => 'error', 'message' => 'Institute folder not found. Please log in again and try.']);
                exit;
            }

            // Prepare upload path
            $uploadDir = "../institutes/$folderName/study_materials/";
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $encryptedName = hash('sha256', uniqid('', true)) . '.' . $fileExt;
            $targetPath = $uploadDir . $encryptedName;

            if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
                echo json_encode(['status' => 'error', 'message' => 'File upload failed']);
                exit;
            }

            $actual_file_name = $encryptedName;
        }

        // Insert study material
        $insertStmt = $pdo->prepare("
            INSERT INTO study_material (title, vimeo_link, original_file_name, actual_file_name, doc_type, institute_id, category_id, description, is_block)
            VALUES (:title, :vimeo_link, :original_file_name, :actual_file_name, :doc_type, :institute_id, :category_id, :description, :is_block)
        ");
        $insertStmt->execute([
            ':title' => $title,
            ':vimeo_link' => $vimeo_link,
            ':original_file_name' => $original_file_name,
            ':actual_file_name' => $actual_file_name,
            ':doc_type' => $doc_type,
            ':institute_id' => $institute_id,
            ':category_id' => $course_category,
            ':is_block' => $block_content,
            ':description' => $desc
        ]);
        $study_material_id = $pdo->lastInsertId();


        echo json_encode(['status' => 'success', 'message' => 'File uploaded successfully.']);

    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'Unexpected error: ' . $e->getMessage()]);
    }
    exit;
}