<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['first_name']) && !empty($data['first_name']) &&
    isset($data['last_name']) && !empty($data['last_name']) &&
    isset($data['phone_no']) && !empty($data['phone_no']) &&
    isset($data['email_id']) && !empty($data['email_id']) &&
    isset($data['password']) && !empty($data['password']) && isset($data['role_name']) && !empty($data['role_name'])) {

    $firstName = trim($data['first_name']);
    $lastName = trim($data['last_name']);
    $mobileNo = trim($data['phone_no']);
    $emailId = trim($data['email_id']);
    $role_name = implode(',', $data['role_name']);
    $password = base64_encode(trim($data['password']));
    $address = trim($data['address']);
    $blockEmployee = $data['block_employee'];
    
    $user_name = $firstName .' '.$lastName;

} else {
    echo json_encode(["status" => "error", "message" => "All fields are required."]);
    exit();
}

try {
    $user_id = $_SESSION['user_id'];
    $institute_id = $_SESSION['institute_id'];
    $category = 'employee';
    
    // Check if any employee with the same mobile number or email already exists
    $checkSql = "SELECT COUNT(*) FROM employee_master WHERE phone_no = :phone_no OR email_id = :email_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->bindParam(':phone_no', $mobileNo);
    $checkStmt->bindParam(':email_id', $emailId);

    // Execute the query
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        echo json_encode(["status" => "error", "message" => "Mobile number or email already exists."]);
        exit();
    }

    $insertUserSql = "INSERT INTO user_master (category, email_id, phone_no, password, user_name, created_by, is_block, institute_id) 
                      VALUES (:category, :email_id, :phone_no, :password, :user_name, :user_id, :block, :institute_id)";
    $insertUserStmt = $pdo->prepare($insertUserSql);
    
    // Bind parameters for the user table
    $insertUserStmt->bindParam(':email_id', $emailId);
    $insertUserStmt->bindParam(':phone_no', $mobileNo);
    $insertUserStmt->bindParam(':password', $password);
    $insertUserStmt->bindParam(':category', $category);
    $insertUserStmt->bindParam(':user_id', $user_id);
    $insertUserStmt->bindParam(':user_name', $user_name);
    $insertUserStmt->bindParam(':block', $blockEmployee);
    $insertUserStmt->bindParam(':institute_id', $institute_id);
    
    // Execute the user insert query
    $insertUserStmt->execute();

    // Get the user_id generated for the user (the primary key of the user)
    $user_id = $pdo->lastInsertId();
        
        
    $sql = "INSERT INTO employee_master (first_name, last_name, phone_no, email_id, role_id, password, address, is_block, user_id, institute_id)
            VALUES (:first_name, :last_name, :phone_no, :email_id, :roles, :password, :address, :block_employee, :user_id, :institute_id)";
    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':first_name', $firstName);
    $stmt->bindParam(':last_name', $lastName);
    $stmt->bindParam(':phone_no', $mobileNo);
    $stmt->bindParam(':email_id', $emailId);
    $stmt->bindParam(':password', $password);
    $stmt->bindParam(':roles', $role_name);
    $stmt->bindParam(':address', $address);
    $stmt->bindParam(':block_employee', $blockEmployee);
    $stmt->bindParam(':user_id', $user_id);
    $stmt->bindParam(':institute_id', $institute_id);

    $stmt->execute();

    echo json_encode(["status" => "success", "message" => "Employee added successfully!"]);

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>