<?php
require_once ('../includes/connection.php'); // Database connection
session_start();

header('Content-Type: application/json');
    $user_id = $_SESSION['user_id'];
    $institute_id = $_SESSION['institute_id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $faq_question = trim($_POST['faq_question'] ?? '');
    $faq_answer = trim($_POST['faq_answer'] ?? '');
    $is_block = isset($_POST['is_block']) ? (int)$_POST['is_block'] : 0;

    if (empty($faq_question)) {
        echo json_encode(['status' => 'error', 'message' => 'FAQ question is required.']);
        exit;
    }

    try {
        $sql = "INSERT INTO faq_master (institute_id, faq_question, faq_answer, is_block, created_by) VALUES (:institute_id, :faq_question, :faq_answer, :is_block, :created_by)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);
        $stmt->bindParam(':faq_question', $faq_question, PDO::PARAM_STR);
        $stmt->bindParam(':faq_answer', $faq_answer, PDO::PARAM_STR);
        $stmt->bindParam(':is_block', $is_block, PDO::PARAM_INT);
        $stmt->bindParam(':created_by', $user_id, PDO::PARAM_INT);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'FAQ added successfully!']);
    } 
    catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
