<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['module_name']) && !empty($data['module_name'])) {
    $moduleName = trim($data['module_name']);
    $description = isset($data['description']) ? $data['description'] : '';
    $status = isset($data['status']) ? $data['status'] : '';

} else {
    echo json_encode(["status" => "error", "message" => "Module name is required"]);
    exit();
}

try {
    $user_id = $_SESSION['user_id'];
    $institute_id = $_SESSION['institute_id'];

    // Prepare the SQL query to check if the module_name already exists
    $checkSql = "SELECT COUNT(*) FROM module_master WHERE module_name = :module_name AND institute_id = :institute_id";
    $checkStmt = $pdo->prepare($checkSql);

    $checkStmt->bindParam(':module_name', $moduleName);
    $checkStmt->bindParam(':institute_id', $institute_id);
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        echo json_encode(["status" => "error","message" => "Module already exists."]);
    } else {
        $insertSql = "INSERT INTO module_master (module_name, description, created_by, institute_id, is_block) 
                      VALUES (:module_name ,:description, :user_id, :institute_id, :status)";
        $insertStmt = $pdo->prepare($insertSql);

        // Bind the parameters and execute the insert statement
        $insertStmt->bindParam(':module_name', $moduleName);
        $insertStmt->bindParam(':description', $description);
        $insertStmt->bindParam(':user_id', $user_id);
        $insertStmt->bindParam(':institute_id', $institute_id);
        $insertStmt->bindParam(':status', $status);
        $insertStmt->execute();

        echo json_encode(["status" => "success","message" => "Module created successfully!"]);
    }

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>