<?php

require_once('../includes/connection.php');
require('../vendor/autoload.php');

use Vimeo\Vimeo;

// Vimeo credentials
$clientId = "5aa41d66ac6c8c8f7ac864af4455b38e58124df5";
$clientSecret = "f9VSklt+8WdIEFjYZAR5Q+gdo6z+ZgJWPpcCeuQWsEpOG8ksBRHLJlnRgl0mJ6QyJv6Khcf5tiP4AplxYCpoeTlKisXZAUz5LombPknL7wTfpSmbdtupJGW/7OBM5";
$accessToken = "59049690f9eb19c23cd3aaa17a2c759e";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (empty($_POST['module_name']) || empty($_POST['draft_id']) || !isset($_FILES['study_file']) || $_FILES['study_file']['error'] !== UPLOAD_ERR_OK) {
        echo json_encode(['success' => false, 'message' => 'Missing required fields or invalid file']);
        exit;
    }

    $moduleName = $_POST['module_name'];
    $vidtitle = $_POST['vidtitle'];
    $courseDraftId = $_POST['draft_id'];
    $fileTmp = $_FILES['study_file']['tmp_name'];
    $fileName = $_FILES['study_file']['name'];
    $fileType = mime_content_type($fileTmp);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    $allowedVideoTypes = ['video/mp4', 'video/avi', 'video/mov', 'video/mkv'];
    $allowedDocTypes = ['application/pdf', 'image/jpeg', 'image/png'];

    try {
        // === 1. Check if module already exists ===
        $stmt = $pdo->prepare("SELECT module_id, study_material FROM module_master WHERE module_name = :module_name");
        $stmt->execute([':module_name' => $moduleName]);
        $existingModule = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($existingModule) {
            $moduleId = $existingModule['module_id'];
        } else {
            $stmt = $pdo->prepare("INSERT INTO module_master (module_name) VALUES (:module_name)");
            $stmt->execute([':module_name' => $moduleName]);
            $moduleId = $pdo->lastInsertId();
        }

        // === 2. Insert into course_draft_modules if not exists ===
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM course_draft_modules WHERE course_draft_id = :draft_id AND module_id = :module_id");
        $stmt->execute([':draft_id' => $courseDraftId, ':module_id' => $moduleId]);
        if ($stmt->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO course_draft_modules (course_draft_id, module_id) VALUES (:draft_id, :module_id)");
            $stmt->execute([':draft_id' => $courseDraftId, ':module_id' => $moduleId]);
        }

        // === 3. Handle file upload ===
        if (in_array($fileType, $allowedVideoTypes)) {
            $client = new Vimeo($clientId, $clientSecret, $accessToken);

            $uri = $client->upload($fileTmp, [
                "name" => $moduleName,
                "description" => "Uploaded for module: $moduleName",
            ]);

            $response = $client->request($uri . '?fields=transcode.status');
            $transcodeStatus = $response['body']['transcode']['status'];

            $statusMsg = ($transcodeStatus === 'complete') ? 'Your video finished transcoding.' :
                         (($transcodeStatus === 'in_progress') ? 'Video uploaded successfully.' :
                         'Your video encountered an error during transcoding.');

            $response = $client->request($uri . '?fields=link');
            $videoLink = $response['body']['link'];
            $videoId = explode("/", $videoLink)[3];

            $stmt = $pdo->prepare("INSERT INTO study_material (vimeo_link, title) VALUES (:vimeo_link, :title)");
            $stmt->execute([':vimeo_link' => $videoId, ':title' => $vidtitle]);
            $studyId = $pdo->lastInsertId();

        } elseif (in_array($fileType, $allowedDocTypes)) {
            $uploadDir = '../study/';
            if (!file_exists($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            $destination = $uploadDir . basename($fileName);

            if (!move_uploaded_file($fileTmp, $destination)) {
                echo json_encode(['success' => false, 'message' => 'Failed to move uploaded file.']);
                exit;
            }

            $stmt = $pdo->prepare("INSERT INTO study_material (actual_file_name, title) VALUES (:actual_file_name, :title)");
            $stmt->execute([':actual_file_name' => $fileName, ':title' => $vidtitle]);
            $studyId = $pdo->lastInsertId();

            $statusMsg = 'Document uploaded successfully.';
        } else {
            echo json_encode(['success' => false, 'message' => 'Unsupported file type.']);
            exit;
        }

        // === 4. Update module_master's study_material field ===
        $existingStudyMaterial = $existingModule ? $existingModule['study_material'] : '';
        $newStudyMaterial = trim($existingStudyMaterial . ',' . $studyId, ',');

        $stmt = $pdo->prepare("UPDATE module_master SET study_material = :study_material WHERE module_id = :module_id");
        $stmt->execute([':study_material' => $newStudyMaterial, ':module_id' => $moduleId]);

        // echo json_encode(['success' => true, 'message' => $statusMsg]);
        echo json_encode([
            'success' => true,
            'message' => $statusMsg,
            'content_id' => $studyId, // The ID of the newly added study material
            'module_id' => $moduleId  // The ID of the module it belongs to
        ]);
        exit;

    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
        exit;
    }

} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
