<?php
require_once('../includes/connection.php');
require_once('emailer.php');
header('Content-Type: application/json');

// Check required fields
if (
    isset($_POST['email_address']) && !empty($_POST['email_address']) &&
    isset($_POST['phone_number']) && !empty($_POST['phone_number']) &&
    isset($_POST['studentname']) && !empty($_POST['studentname']) &&
    isset($_POST['gender']) && !empty($_POST['gender']) &&
    isset($_POST['institute_id']) && !empty($_POST['institute_id'])
) {
    $email = trim($_POST['email_address']);
    $phone = trim($_POST['phone_number']);
    
    // Auto-generate random password (8-character alphanumeric)
    $password = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 8);
    $password_encoded = base64_encode($password);

    $dob = isset($_POST['date_of_birth']) ? trim($_POST['date_of_birth']) : '';
    $gender = trim($_POST['gender']);
    $is_block = 0;
    $category = 'student';
    $student_name = trim($_POST['studentname']);
    $institute_id = $_POST['institute_id'];

} else {
    echo json_encode(["status" => "error", "message" => "All required fields must be filled."]);
    exit();
}

try {
    
    $user_id = $_SESSION['user_id'];
    
    // Check for existing email
    $stmtEmail = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE email_id = :email");
    $stmtEmail->bindParam(':email', $email);
    $stmtEmail->execute();
    if ($stmtEmail->fetchColumn() > 0) {
        echo json_encode(["status" => "error", "message" => "Email already exists."]);
        exit();
    }

    // Check for existing phone number
    $stmtPhone = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE phone_no = :phone");
    $stmtPhone->bindParam(':phone', $phone);
    $stmtPhone->execute();
    if ($stmtPhone->fetchColumn() > 0) {
        echo json_encode(["status" => "error", "message" => "Phone number already exists."]);
        exit();
    }

    // Insert into user_master
    $insertUser = $pdo->prepare("
        INSERT INTO user_master (category, email_id, phone_no, password, user_name, created_by, is_block, institute_id)
        VALUES (:category, :email, :phone, :password, :username, :created_by, :is_block, :institute_id)
    ");
    $insertUser->execute([
        ':category' => $category,
        ':email' => $email,
        ':phone' => $phone,
        ':password' => $password_encoded,
        ':username' => $student_name,
        ':created_by' => $user_id,
        ':is_block' => $is_block,
        ':institute_id' => $institute_id
    ]);

    $userstudent_id = $pdo->lastInsertId();

    // Insert into student_master
    $insertStudent = $pdo->prepare("
        INSERT INTO student_master (user_id, student_name, password, email_id, phone_no, dob, gender, created_by, is_block, institute_id)
        VALUES (:user_id, :student_name, :password, :email, :phone, :dob, :gender, :created_by, :is_block, :institute_id)
    ");
    $insertStudent->execute([
        ':user_id' => $userstudent_id,
        ':student_name' => $student_name,
        ':email' => $email,
        ':phone' => $phone,
        ':password' => $password_encoded,
        ':dob' => $dob,
        ':gender' => $gender,
        ':created_by' => $user_id,
        ':is_block' => $is_block,
        ':institute_id' => $institute_id
    ]);

    // Send welcome email
    $emailSent = sendStudentWelcomeEmail($email, $student_name, $password);

    if ($emailSent) {
        echo json_encode(["status" => "success", "message" => "Student added successfully. Their login credentials have been sent via email."]);
    } else {
        echo json_encode(["status" => "warning", "message" => "Student added successfully, but we were unable to send the login credentials via email."]);
    }

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
}
?>
