<?php
require_once ('../includes/connection.php'); // Database connection
session_start();
  
header('Content-Type: application/json');
$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

// if (!$user_id || !$institute_id) {
//     echo json_encode(['status' => 'error', 'message' => 'Unauthorized access.']);
//     exit;
// }

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $testimonial_name = trim($_POST['testimonial_name'] ?? '');
    $learner_since = trim($_POST['learner_since'] ?? '');
    $testimonial_text = trim($_POST['testimonial_text'] ?? '');
    $is_block = isset($_POST['is_block']) ? (int)$_POST['is_block'] : 0;
    $created_at = date('Y-m-d H:i:s');

    // Ensure required fields are not blank
    if (empty($testimonial_name) || empty($learner_since) || empty($testimonial_text)) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
        exit;
    }

    try {
        $sql = "INSERT INTO testimonial_master (institute_id, testimonial_name, learner_since, testimonial_text, is_block, created_at, created_by) 
                VALUES (:institute_id, :testimonial_name, :learner_since, :testimonial_text, :is_block, :created_at, :created_by)";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);
        $stmt->bindParam(':testimonial_name', $testimonial_name, PDO::PARAM_STR);
        $stmt->bindParam(':learner_since', $learner_since, PDO::PARAM_STR);
        $stmt->bindParam(':testimonial_text', $testimonial_text, PDO::PARAM_STR);
        $stmt->bindParam(':is_block', $is_block, PDO::PARAM_INT);
        $stmt->bindParam(':created_at', $created_at, PDO::PARAM_STR);
        $stmt->bindParam(':created_by', $user_id, PDO::PARAM_INT);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Testimonial added successfully!']);
    } 
    catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
