<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'category_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');
    $category_id = $_POST['category_id'] ?? '';

    // Validate sort direction
    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    // Allowed sort fields
    $allowedSortFields = ['category_id', 'is_block', 'category_name'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'category_id';
    }

    // Base WHERE clause
    $searchQuery = "WHERE is_deleted != 1";
    $searchParams = [];

    // Filter by category ID
    if (!empty($category_id)) {
        $searchQuery .= " AND category_id = ?";
        $searchParams[] = $category_id;
    }

    // Search by keyword
    if (!empty($searchValue)) {
        $like = "%$searchValue%";
        $searchQuery .= " AND (category_name LIKE ?";
        $searchParams[] = $like;

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    // Total unfiltered records
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM category_master WHERE is_deleted != 1")->fetchColumn();

    // Total filtered records
    $countSql = "SELECT COUNT(*) FROM category_master $searchQuery";
    $countStmt = $pdo->prepare($countSql);
    $countStmt->execute($searchParams);
    $filteredRecords = $countStmt->fetchColumn();

    // Fetch filtered, paginated records
    $dataSql = "
        SELECT category_id, category_name, is_block
        FROM category_master
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $finalParams = array_merge($searchParams, [$start, $length]);
    $dataStmt->execute($finalParams);
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}