<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

$course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : 0;

if (!$course_id) {
    echo json_encode(['success' => false, 'message' => 'Course ID missing']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        UPDATE course_master
        SET is_block = 1
        WHERE course_id = :id
    ");
    $stmt->bindParam(':id', $course_id, PDO::PARAM_INT);
    $stmt->execute();

if ($stmt->rowCount() > 0) {
    echo json_encode(['success' => true, 'message' => 'Course deleted successfully.']);
} else {
    echo json_encode(['success' => false, 'message' => 'No course found to delete.']);
}
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
