<?php

require_once('../includes/connection.php');

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

if (empty($_POST['module_id'])) {
    echo json_encode(['success' => false, 'message' => 'Module ID is required']);
    exit;
}

$moduleId = $_POST['module_id'];

try {
    // Get associated study_material IDs
    // $stmt = $pdo->prepare("SELECT study_material FROM module_master WHERE module_id = :module_id");
    // $stmt->execute([':module_id' => $moduleId]);
    // $module = $stmt->fetch(PDO::FETCH_ASSOC);

    // if (!$module) {
    //     echo json_encode(['success' => false, 'message' => 'Module not found']);
    //     exit;
    // }

    // Delete from course_draft_modules
    $stmt = $pdo->prepare("DELETE FROM course_draft_modules WHERE module_id = :module_id");
    $stmt->execute([':module_id' => $moduleId]);

    // Delete associated study_materials
    $studyIds = explode(',', $module['study_material']);
    foreach ($studyIds as $id) {
        if (is_numeric($id)) {
            $stmt = $pdo->prepare("DELETE FROM study_material WHERE id = :id");
            $stmt->execute([':id' => $id]);
        }
    }

    // Delete from module_master
    $stmt = $pdo->prepare("DELETE FROM module_master WHERE module_id = :module_id");
    $stmt->execute([':module_id' => $moduleId]);

    echo json_encode(['success' => true, 'message' => 'Module and related data deleted successfully']);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
}
