<?php
header('Content-Type: application/json');
require_once('../includes/connection.php'); // Adjust this path

$moduleId = isset($_POST['module_id']) ? intval($_POST['module_id']) : 0;
$contentId = isset($_POST['content_id']) ? trim($_POST['content_id']) : '';

if (!$moduleId || $contentId === '') {
    echo json_encode(['success' => false, 'message' => 'Invalid module_id or content_id']);
    exit;
}

try {
    // 1. Fetch current study_material for the module
    $sqlFetch = "SELECT study_material FROM module_master WHERE module_id = :module_id";
    $stmtFetch = $pdo->prepare($sqlFetch);
    $stmtFetch->execute([':module_id' => $moduleId]);
    $row = $stmtFetch->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode(['success' => false, 'message' => 'Module not found']);
        exit;
    }

    $materials = explode(',', $row['study_material']);
    // Remove the contentId from the array
    $materials = array_filter($materials, function($val) use ($contentId) {
        return trim($val) !== $contentId;
    });

    // Rebuild the study_material string
    $newStudyMaterial = implode(',', $materials);

    // 2. Update the module_master table with new study_material
    $sqlUpdate = "UPDATE module_master SET study_material = :study_material WHERE module_id = :module_id";
    $stmtUpdate = $pdo->prepare($sqlUpdate);
    $stmtUpdate->execute([
        ':study_material' => $newStudyMaterial,
        ':module_id' => $moduleId
    ]);

    echo json_encode([
        'success' => true,
        'module_id' => $moduleId,
        'removed_content_id' => $contentId,
        'updated_study_material' => $newStudyMaterial
    ]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
