<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if employeeId is set
if (isset($data['employee_id']) && !empty($data['employee_id'])) {
    $employeeId = (int)$data['employee_id']; // Convert employee_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "employee ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the employee
    
    $sql = "UPDATE employee_master SET is_deleted = '1' WHERE employee_id= :employee_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':employee_id', $employeeId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the employee was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Employee deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Employee not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>