<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if institute_id is set
if (isset($data['institute_id']) && !empty($data['institute_id'])) {
    $instituteId = (int)$data['institute_id']; // Convert institute_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "Institute ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE institute_master SET is_deleted = '1' WHERE institute_id= :institute_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':institute_id', $instituteId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Institute deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Institute not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>