<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if mentor_id is set
if (isset($data['mentor_id']) && !empty($data['mentor_id'])) {
    $instituteId = (int)$data['mentor_id']; // Convert mentor_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "Institute ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE mentor_master SET is_deleted = '1' WHERE mentor_id= :mentor_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':mentor_id', $instituteId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Mentor deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Mentor not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>