<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if question_master_id is set
if (isset($data['question_master_id']) && !empty($data['question_master_id'])) {
    $questionId = (int)$data['question_master_id']; 
} else {
    echo json_encode(["status" => "error", "message" => "Question ID is required"]);
    exit();
}
 
try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE question_master SET is_deleted = '1' WHERE question_master_id= :question_master_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':question_master_id', $questionId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Question deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Question not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>