<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if quiz_id is set
if (isset($data['quiz_id']) && !empty($data['quiz_id'])) {
    $questionId = (int)$data['quiz_id']; 
} else {
    echo json_encode(["status" => "error", "message" => "Quiz ID is required"]);
    exit();
}
 
try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE quiz_master SET is_deleted = '1' WHERE quiz_id= :quiz_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':quiz_id', $questionId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Quiz deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Quiz not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>