<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if subsubmodule_id is set
if (isset($data['submodule_id']) && !empty($data['submodule_id'])) {
    $submoduleId = (int)$data['submodule_id']; // Convert subsubmodule_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "Submodule ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE submodule_master SET is_deleted = '1' WHERE submodule_id= :submodule_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':submodule_id', $submoduleId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Submodule deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Submodule not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>