<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if Testimonial_master_id is set
if (isset($data['testimonial_id']) && !empty($data['testimonial_id'])) {
    $TestimonialId = (int)$data['testimonial_id']; 
} else {
    echo json_encode(["status" => "error", "message" => "Testimonial ID is required"]);
    exit();
}
 
try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE testimonial_master SET is_deleted = '1' WHERE testimonial_id= :testimonial_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':testimonial_id', $TestimonialId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Testimonial deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Testimonial not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>