<?php
require_once('../includes/connection.php');
$institute_id = $_SESSION['institute_id'];
$draft_id = isset($_GET['draft_id']) ? intval($_GET['draft_id']) : 0;

try {
    $sql = "
        SELECT 
            m.module_id,
            m.module_name,
            m.description,
            cdm.sub_modules,
            GROUP_CONCAT(s.submodule_name) AS submodule_names
        FROM 
            course_draft_modules cdm
        INNER JOIN 
            module_master m ON cdm.module_id = m.module_id
        LEFT JOIN 
            submodule_master s ON FIND_IN_SET(s.submodule_id, cdm.sub_modules)
        WHERE 
            cdm.course_draft_id = :draft_id
            AND m.is_block != 1
            AND m.institute_id = :institute_id
        GROUP BY 
            m.module_id, cdm.draft_module_id
        ORDER BY 
            cdm.draft_module_id ASC
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':draft_id', $draft_id, PDO::PARAM_INT);
    $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);
    $stmt->execute();

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    header('Content-Type: application/json');
    echo json_encode($data);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
