<?php
require_once('../includes/connection.php'); // Make sure this creates $pdo (PDO instance)
header('Content-Type: application/json');

$filtermoduleId = isset($_GET['module_id']) ? intval($_GET['module_id']) : null;



try {
    // Fetch Modules
    $stmt = $pdo->prepare("SELECT module_id AS id, module_name AS name FROM module_master WHERE is_block != 1");
    $stmt->execute();
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Fetch Sub Modules
if ($filtermoduleId) {
    $stmt = $pdo->prepare("SELECT submodule_id AS id, submodule_name AS name FROM submodule_master WHERE is_block != 1 AND module_id = :module_id");
    $stmt->bindParam(':module_id', $filtermoduleId, PDO::PARAM_INT);
}
$stmt->execute();
$sub_modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Fetch Course Materials
    $stmt = $pdo->prepare("SELECT study_material_id AS id, title AS name FROM study_material WHERE is_block != 1");
    $stmt->execute();
    $course_materials = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch Category
    $stmt = $pdo->prepare("SELECT category_id AS id, category_name AS name FROM category_master WHERE is_block != 1");
    $stmt->execute();
    $category = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch Course
    $stmt = $pdo->prepare("SELECT course_id AS id, course_title AS name FROM course_master WHERE is_block != 1");
    $stmt->execute();
    $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch Testimonials
    $stmt = $pdo->prepare("SELECT testimonial_id AS id, testimonial_name AS name FROM testimonial_master WHERE is_block != 1");
    $stmt->execute();
    $testimonials = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch Mentor
    $stmt = $pdo->prepare("SELECT mentor_id AS id, mentor_name AS name FROM mentor_master WHERE is_block != 1");
    $stmt->execute();
    $mentors = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch Proposed Courses
    $stmt = $pdo->prepare("SELECT course_id AS id, course_title AS name FROM course_master WHERE TRIM(course_title) != '' ");
    $stmt->execute();
    $proposed_courses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch Institutes
    $stmt = $pdo->prepare("SELECT institute_id AS id, institute_name AS name FROM institute_master WHERE TRIM(institute_name) != '' ");
    $stmt->execute();
    $institutes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Fetch Countries
    $stmt = $pdo->prepare("SELECT id, name FROM country WHERE TRIM(name) != '' ");
    $stmt->execute();
    $countries = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    
    $stmt = $pdo->prepare("SELECT course_id AS id, course_title AS name FROM course_master WHERE TRIM(course_title) != '' AND is_publish = 1");
    $stmt->execute();
    $courses_public = $stmt->fetchAll(PDO::FETCH_ASSOC);
    

    // Fetch FAQs
    $stmt = $pdo->prepare("SELECT faq_id AS id, faq_question AS name FROM faq_master WHERE TRIM(faq_question) != '' ");
    $stmt->execute();
    $faqs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    

    // Combine and respond
    $response = [
        'modules' => $modules,
        'sub_modules' => $sub_modules,
        'course_materials' => $course_materials,
        'categories' => $category,
        'courses' => $courses,
        'testimonials' => $testimonials,
        'mentors' => $mentors,
        'proposed_courses' => $proposed_courses,
        'courses_public' => $courses_public,
        'institutes' => $institutes,
        'countries' => $countries,
        'faqs' => $faqs
        
    ];

    echo json_encode($response);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database Error: ' . $e->getMessage()]);
}
?>
