<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    if (!isset($_POST['course_id']) || empty($_POST['course_id'])) {
        throw new Exception("Course ID is required.");
    }

    $courseId = intval($_POST['course_id']);

    $pdo->beginTransaction();

    // 1️⃣ Clone course_master
    $stmt = $pdo->prepare("SELECT * FROM course_master WHERE course_id = :course_id");
    $stmt->execute([':course_id' => $courseId]);
    $course = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$course) throw new Exception("Course not found.");

    unset($course['course_id']); // PK
    $course['course_title'] .= " CLONE";

    $columns = implode(",", array_keys($course));
    $placeholders = ":" . implode(",:", array_keys($course));
    $insert = $pdo->prepare("INSERT INTO course_master ($columns) VALUES ($placeholders)");
    $insert->execute($course);
    $newCourseId = $pdo->lastInsertId();

    // 2️⃣ Clone course_module
    $stmt = $pdo->prepare("SELECT * FROM course_module WHERE course_id = :course_id");
    $stmt->execute([':course_id' => $courseId]);
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $moduleIdMap = [];
    foreach ($modules as $module) {
        $oldModuleId = $module['course_module_id'];
        unset($module['course_module_id']); // Correct PK
        $module['course_id'] = $newCourseId;

        $columns = implode(",", array_keys($module));
        $placeholders = ":" . implode(",:", array_keys($module));
        $insert = $pdo->prepare("INSERT INTO course_module ($columns) VALUES ($placeholders)");
        $insert->execute($module);
        $moduleIdMap[$oldModuleId] = $pdo->lastInsertId();
    }

    // 3️⃣ Clone course_submodule
    $stmt = $pdo->prepare("SELECT * FROM course_submodule WHERE course_id = :course_id");
    $stmt->execute([':course_id' => $courseId]);
    $submodules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($submodules as $sub) {
        unset($sub['course_submodule_id']); // Correct PK
        $sub['course_id'] = $newCourseId;
        if (isset($moduleIdMap[$sub['course_module_id']])) {
            $sub['course_module_id'] = $moduleIdMap[$sub['course_module_id']];
        }

        $columns = implode(",", array_keys($sub));
        $placeholders = ":" . implode(",:", array_keys($sub));
        $insert = $pdo->prepare("INSERT INTO course_submodule ($columns) VALUES ($placeholders)");
        $insert->execute($sub);
    }

    // 4️⃣ Clone course_quiz
    $stmt = $pdo->prepare("SELECT * FROM course_quiz WHERE course_id = :course_id");
    $stmt->execute([':course_id' => $courseId]);
    $quizzes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($quizzes as $quiz) {
        unset($quiz['course_quiz_id']); // Correct PK
        $quiz['course_id'] = $newCourseId;

        $columns = implode(",", array_keys($quiz));
        $placeholders = ":" . implode(",:", array_keys($quiz));
        $insert = $pdo->prepare("INSERT INTO course_quiz ($columns) VALUES ($placeholders)");
        $insert->execute($quiz);
    }

    // 5️⃣ Clone course_assignment
    $stmt = $pdo->prepare("SELECT * FROM course_assignment WHERE course_id = :course_id");
    $stmt->execute([':course_id' => $courseId]);
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($assignments as $assign) {
        unset($assign['course_assignment_id']); // Correct PK
        $assign['course_id'] = $newCourseId;

        $columns = implode(",", array_keys($assign));
        $placeholders = ":" . implode(",:", array_keys($assign));
        $insert = $pdo->prepare("INSERT INTO course_assignment ($columns) VALUES ($placeholders)");
        $insert->execute($assign);
    }

    $pdo->commit();

    echo json_encode([
        'status' => 'success',
        'message' => 'Course duplicated successfully.',
        'new_course_id' => $newCourseId
    ]);

} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
