<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Validate required fields
if (!isset($_POST['question_master_id']) || empty($_POST['question_master_id'])) {
    echo json_encode(["status" => "error", "message" => "Required fields are missing"]);
    exit();
}

$questionId = trim($_POST['question_master_id']);

try {
    // Fetch the original question
    $sql = "SELECT * FROM question_master WHERE question_master_id = :question_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':question_id', $questionId);
    $stmt->execute();

    // Check if the question exists
    $questionData = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$questionData) {
        echo json_encode(["status" => "error", "message" => "Question not found"]);
        exit();
    }

    // Prepare data for the new duplicate question
    $categoryCourseId = $questionData['category_course_id'];
    $courseId = $questionData['course_id'];
    $moduleId = $questionData['module_id'];
    $submoduleId = $questionData['submodule_id'];
    $type = $questionData['type'];
    $criteria = $questionData['criteria'];
    $level = $questionData['level'];
    $media = $questionData['media'];
    $question = $questionData['question'];
    $videoType = $questionData['video_type'];
    $videoUrl = $questionData['video_url'];
    $hint = $questionData['hint'];
    $marks = $questionData['marks'];
    $createdBy = $_SESSION['user_id'];
    $instituteId = $_SESSION['institute_id'];
    $is_active = $_SESSION['is_active'];

    // Check if there is an image and assign it
    $imageUrl = $questionData['image_url'] ?? null;

    // Handle options for multiple choice question types
    $option1 = $questionData['option_1'];
    $option2 = $questionData['option_2'];
    $option3 = $questionData['option_3'];
    $option4 = $questionData['option_4'];

    // Handle correct answer for multiple right answers
    $correctAnswer = $questionData['correct_answer'];

    // Insert duplicate query
    $sql = "INSERT INTO question_master 
            (category_course_id, course_id, module_id, submodule_id, type, criteria, level, media, question, video_type, video_url, image_url, option_1, option_2, option_3, option_4, correct_answer, hint, marks, created_by, institute_id, created_date, is_active)
            VALUES 
            (:category_course_id, :course_id, :module_id, :submodule_id, :type, :criteria, :level, :media, :question, :video_type, :video_url, :image_url, :option_1, :option_2, :option_3, :option_4, :correct_answer, :hint, :marks, :created_by, :institute_id, NOW(), :is_active)";

    $stmt = $pdo->prepare($sql);

    // Bind parameters for duplication
    $stmt->bindParam(':category_course_id', $categoryCourseId);
    $stmt->bindParam(':course_id', $courseId);
    $stmt->bindParam(':module_id', $moduleId);
    $stmt->bindParam(':submodule_id', $submoduleId);
    $stmt->bindParam(':type', $type);
    $stmt->bindParam(':criteria', $criteria);
    $stmt->bindParam(':level', $level);
    $stmt->bindParam(':media', $media);
    $stmt->bindParam(':question', $question);
    $stmt->bindParam(':video_type', $videoType);
    $stmt->bindParam(':video_url', $videoUrl);
    $stmt->bindParam(':image_url', $imageUrl);
    $stmt->bindParam(':option_1', $option1);
    $stmt->bindParam(':option_2', $option2);
    $stmt->bindParam(':option_3', $option3);
    $stmt->bindParam(':option_4', $option4);
    $stmt->bindParam(':correct_answer', $correctAnswer);
    $stmt->bindParam(':hint', $hint);
    $stmt->bindParam(':marks', $marks);
    $stmt->bindParam(':created_by', $createdBy);
    $stmt->bindParam(':institute_id', $instituteId);
    $stmt->bindParam(':is_active', $is_active);

    // Execute the query
    $stmt->execute();

    echo json_encode(["status" => "success", "message" => "Question duplicated successfully!"]);

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>
