<?php

header('Content-Type: application/json');
session_start();
require_once('../includes/connection.php'); // Make sure this is included

// Safely read POST data
$assignmentIdEncoded = $_POST['assignmentId'] ?? '';
$assignmentTitle = trim($_POST['assignmentTitle'] ?? '');
$rawQuestions = $_POST['selected_questions'] ?? '';

// Validate inputs
if (empty($assignmentIdEncoded) || empty($assignmentTitle) || empty($rawQuestions)) {
    echo json_encode([
        "status" => "error",
        "message" => "Assignment ID, title and questions are required."
    ]);
    exit();
}

// Decode and parse
$assignmentId = base64_decode($assignmentIdEncoded);
$questionIds = json_decode($rawQuestions, true);

if (!is_array($questionIds) || count($questionIds) === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Please select at least one question."
    ]);
    exit();
}

try {
    $user_id = $_SESSION['user_id'] ?? 0;

    $questionIdsString = implode(',', array_map('intval', $questionIds));

    $updateassignmentSql = "UPDATE assignment_master 
                      SET assignment_title = :assignment_title, 
                          question_ids = :question_ids 
                      WHERE assignment_id = :assignment_id AND created_by = :created_by";

    $stmt = $pdo->prepare($updateassignmentSql);
    $stmt->bindParam(':assignment_title', $assignmentTitle);
    $stmt->bindParam(':question_ids', $questionIdsString);
    $stmt->bindParam(':assignment_id', $assignmentId, PDO::PARAM_INT);
    $stmt->bindParam(':created_by', $user_id, PDO::PARAM_INT);
    $stmt->execute();

    echo json_encode([
        "status" => "success",
        "message" => "assignment updated successfully!"
    ]);

} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    echo json_encode([
        "status" => "error",
        "message" => "An error occurred while updating the assignment."
    ]);
}