<?php
require_once('../includes/connection.php');

header('Content-Type: application/json');

// Check if course_name is set and is not empty
if (isset($_POST['course_name']) && !empty($_POST['course_name'])) {
    $courseName = trim($_POST['course_name']);
    $courseCategory = isset($_POST['course_category']) ? $_POST['course_category'] : '';
    $level = isset($_POST['level']) ? $_POST['level'] : '';
    $description = isset($_POST['description']) ? $_POST['description'] : '';
    $blockCourse = isset($_POST['block_course']) ? $_POST['block_course'] : '0';
    $courseId = base64_decode($_POST['course_id']);

    // Fetch existing course details
    $query = "SELECT * FROM course_master WHERE course_id = :course_id";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':course_id', $courseId);
    $stmt->execute();
    $course = $stmt->fetch(PDO::FETCH_ASSOC);

    $courseImgPath = $course['course_img'] ?? '';

    // Upload course image (if provided)
    if (isset($_FILES['course_img']) && $_FILES['course_img']['error'] == UPLOAD_ERR_OK) {
        $file = $_FILES['course_img'];
        $fileName = $file['name'];
        $fileTmpPath = $file['tmp_name'];
        $fileSize = $file['size'];
        $fileType = $file['type'];

        // Generate a unique encrypted file name
        $encryptedFileName = bin2hex(random_bytes(16)) . '.' . pathinfo($fileName, PATHINFO_EXTENSION);
        $uploadDir = '../images/course_image/';
        $destPath = $uploadDir . $encryptedFileName;

        // Move the uploaded file to the target directory
        if (move_uploaded_file($fileTmpPath, $destPath)) {
            $courseImgPath = $encryptedFileName; // Update the image path with the new file name
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to upload course image."]);
            exit;
        }
    }

    // Prepare the SQL query to update course data
    try {
        $updateSql = "UPDATE course_master SET 
                        course_name = :course_name, 
                        course_category = :course_category, 
                        level = :level, 
                        description = :description, 
                        is_block = :block_course, 
                        image = :course_img 
                      WHERE course_id = :course_id";

        $updateStmt = $pdo->prepare($updateSql);

        // Bind the parameters and execute the update statement
        $updateStmt->bindParam(':course_name', $courseName);
        $updateStmt->bindParam(':course_category', $courseCategory);
        $updateStmt->bindParam(':level', $level);
        $updateStmt->bindParam(':description', $description);
        $updateStmt->bindParam(':block_course', $blockCourse);
        $updateStmt->bindParam(':course_img', $courseImgPath);
        $updateStmt->bindParam(':course_id', $courseId);

        // Execute the update
        $updateStmt->execute();

        // Prepare the response message
        echo json_encode([
            "status" => "success",
            "message" => "Course updated successfully!"
        ]);
    } catch (Exception $e) {
        echo json_encode([
            "status" => "error",
            "message" => "An error occurred: " . $e->getMessage()
        ]);
    }

} else {
    echo json_encode([
        "status" => "error",
        "message" => "Course name is required."
    ]);
}
?>
