<?php
require_once('../cr/vimeo_upload.php');
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $study_material_id = base64_decode($_POST['study_material_id']) ?? null;
        $title = trim($_POST['study_title']);
        $desc = $_POST['description'];
        $course_category = $_POST['category'];
        $block_content = $_POST['block_content'];

        if (!$study_material_id || !$title || !$course_category) {
            echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
            exit;
        }


        $checkStmt = $pdo->prepare("
            SELECT COUNT(*) FROM study_material 
            WHERE title = :title AND category_id = :category_id 
            AND institute_id = :institute_id AND study_material_id != :id
        ");
        $checkStmt->execute([
            ':title' => $title,
            ':category_id' => $course_category,
            ':institute_id' => $institute_id,
            ':id' => $study_material_id
        ]);
        if ($checkStmt->fetchColumn() > 0) {
            echo json_encode(['status' => 'error', 'message' => 'Study material already exists in the selected category.']);
            exit;
        }


        $stmt = $pdo->prepare("SELECT actual_file_name, original_file_name, vimeo_link, doc_type 
                               FROM study_material 
                               WHERE study_material_id = :id AND institute_id = :institute_id");
        $stmt->execute([':id' => $study_material_id, ':institute_id' => $institute_id]);
        $current = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$current) {
            echo json_encode(['status' => 'error', 'message' => 'Study material not found.']);
            exit;
        }

        $vimeo_link = $current['vimeo_link'];
        $actual_file_name = $current['actual_file_name'];
        $original_file_name = $current['original_file_name'];
        $doc_type = $current['doc_type'];

        // ✅ If new file uploaded
        if (isset($_FILES['study_content']) && $_FILES['study_content']['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES['study_content'];
            $fileTmp = $file['tmp_name'];
            $fileType = mime_content_type($fileTmp);

            $isVideo = strpos($fileType, 'video/') === 0;

            if ($isVideo) {
                // Upload new video to Vimeo first
                $uploadResult = uploadStudyMaterial($file, $title, '');
                if (!$uploadResult || !$uploadResult['success']) {
                    echo json_encode([
                        'status' => 'error',
                        'message' => $uploadResult['message'] ?? 'Vimeo upload failed'
                    ]);
                    exit;
                }


                if ($doc_type === 'video' && !empty($vimeo_link)) {
                    $videoId = basename($vimeo_link);
                    try {
                        $vimeo = new \Vimeo\Vimeo($clientId, $clientSecret, $accessToken);
                        $vimeo->request("/videos/$videoId", [], 'DELETE');
                    } catch (Exception $e) {
                        error_log("Failed to delete old Vimeo video: " . $e->getMessage());
                    }
                }

                $vimeo_link = $uploadResult['video_link'];
                $doc_type = 'video';
                $original_file_name = $file['name'];
                $actual_file_name = $file['name'];

            } else {
                // Validate file extension
                $allowedExts = ['pdf', 'jpg', 'jpeg', 'png', 'ppt', 'pptx', 'txt'];
                $fileExt = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
                if (!in_array($fileExt, $allowedExts)) {
                    echo json_encode(['status' => 'error', 'message' => 'Unsupported file type.']);
                    exit;
                }

                // Get folder_name
                $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
                $stmt->execute([':institute_id' => $institute_id]);
                $folderName = $stmt->fetchColumn();

                if (!$folderName) {
                    echo json_encode(['status' => 'error', 'message' => 'Institute folder not found.']);
                    exit;
                }

                $uploadDir = "../institutes/$folderName/study_materials/";
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }

                $encryptedName = hash('sha256', uniqid('', true)) . '.' . $fileExt;
                $targetPath = $uploadDir . $encryptedName;

                if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
                    echo json_encode(['status' => 'error', 'message' => 'File upload failed']);
                    exit;
                }


                if ($doc_type === 'file' && !empty($actual_file_name)) {
                    $oldPath = $uploadDir . $actual_file_name;
                    if (file_exists($oldPath)) {
                        unlink($oldPath);
                    }
                }

                $actual_file_name = $encryptedName;
                $original_file_name = $file['name'];
                $doc_type = 'file';
                $vimeo_link = ''; // reset if previously video
            }
        }


        $updateStmt = $pdo->prepare("
            UPDATE study_material
            SET title = :title,
                description = :description,
                vimeo_link = :vimeo_link,
                original_file_name = :original_file_name,
                actual_file_name = :actual_file_name,
                doc_type = :doc_type,
                category_id = :category_id,
                is_block = :is_block
            WHERE study_material_id = :id AND institute_id = :institute_id
        ");
        $updateStmt->execute([
            ':title' => $title,
            ':description' => $desc,
            ':vimeo_link' => $vimeo_link,
            ':original_file_name' => $original_file_name,
            ':actual_file_name' => $actual_file_name,
            ':doc_type' => $doc_type,
            ':category_id' => $course_category,
            ':is_block' => $block_content,
            ':id' => $study_material_id,
            ':institute_id' => $institute_id
        ]);

        echo json_encode(['status' => 'success', 'message' => 'Study material updated successfully.']);

    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'Unexpected error: ' . $e->getMessage()]);
    }
    exit;
}
