<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if submodule_name and submodule_id are set
if (isset($data['first_name']) && !empty($data['first_name']) &&
    isset($data['last_name']) && !empty($data['last_name']) &&
    isset($data['phone_no']) && !empty($data['phone_no']) &&
    isset($data['email_id']) && !empty($data['email_id']) &&
    isset($data['password']) && !empty($data['password'])) {

    $firstName = trim($data['first_name']);
    $lastName = trim($data['last_name']);
    $mobileNo = trim($data['phone_no']);
    $emailId = trim($data['email_id']);
    $password = base64_encode(trim($data['password']));
    $address = trim($data['address']);
    $blockEmployee = $data['block_employee']; 
    $roleId = $data['role_id']; 
    $employeeId = base64_decode($data['employee_id']);

} else {
    echo json_encode(["status" => "error", "message" => "Empoyee name and ID are required"]);
    exit();
}

try {
    // Prepare SQL query to check if the submodule already exists (excluding the current category)
    $checkSql = "SELECT COUNT(*) FROM employee_master WHERE (phone_no = :phone_no OR email_id = :email_id) AND employee_id != :employee_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->bindParam(':phone_no', $mobileNo);
    $checkStmt->bindParam(':email_id', $emailId);
    $checkStmt->bindParam(':employee_id', $employeeId);
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        // If the submodule already exists, show an error message
        echo json_encode(["status" => "error", "message" => "Mobile number or email already exists."]);
        exit();
    }

    // Update the submodule if it doesn't exist
    $sql = "UPDATE employee_master SET first_name = :first_name, last_name = :last_name, phone_no = :phone_no, email_id = :email_id, password = :password, address = :address, is_block = :block_employee, role_id = :role_id  WHERE employee_id = :employee_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':first_name', $firstName);
    $stmt->bindParam(':last_name', $lastName);
    $stmt->bindParam(':phone_no', $mobileNo);
    $stmt->bindParam(':email_id', $emailId);
    $stmt->bindParam(':password', $password);
    $stmt->bindParam(':address', $address);
    $stmt->bindParam(':block_employee', $blockEmployee);
    $stmt->bindParam(':role_id', $roleId);
    $stmt->bindParam(':employee_id', $employeeId);
    $stmt->execute();

    // Respond with a success message
    echo json_encode(["status" => "success", "message" => "Employee updated successfully!"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>
