<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (isset($_POST['mentor_name']) && !empty($_POST['mentor_name'])) {
    $mentorName = trim($_POST['mentor_name']);
    $phone_no = $_POST['phone_no'] ?? '';
    $email_id = $_POST['email_id'] ?? '';
    $password = $_POST['password'] ?? '';    
    $specialization = $_POST['specialization'] ?? '';
    $linkedin_profile = $_POST['linkedin_profile'] ?? '';
    $block_mentor = $_POST['block_mentor'] ?? '0';
    $mentorId = base64_decode($_POST['mentor_id']);
    $industry_expert = $_POST['industry_expert'] ?? '0';

    try {
        $user_id = $_SESSION['user_id'];
        $institute_id = $_SESSION['institute_id'];

        // Check for duplicate email
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM mentor_master WHERE email_id = :email_id AND mentor_id != :mentor_id");
        $stmt->execute([':email_id' => $email_id, ':mentor_id' => $mentorId]);
        if ($stmt->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Email ID already exists."]);
            exit;
        }

        // Check for duplicate phone number
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM mentor_master WHERE phone_no = :phone_no AND mentor_id != :mentor_id");
        $stmt->execute([':phone_no' => $phone_no, ':mentor_id' => $mentorId]);
        if ($stmt->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Phone number already exists."]);
            exit;
        }

        // Get folder name
        $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
        $stmt->execute([':institute_id' => $institute_id]);
        $folderName = $stmt->fetchColumn();

        if (!$folderName) {
            throw new Exception("Institute folder not found.");
        }

        $uploadDir = "../institutes/{$folderName}/mentor_images/";

        // Fetch existing mentor details
        $stmt = $pdo->prepare("SELECT photo, cv FROM mentor_master WHERE mentor_id = :mentor_id");
        $stmt->execute([':mentor_id' => $mentorId]);
        $mentor = $stmt->fetch(PDO::FETCH_ASSOC);

        $mentorImgPath = $mentor['photo'] ?? '';
        $mentorCVPath = $mentor['cv'] ?? '';

        // Only process image if a new one is provided
        if (isset($_FILES['mentor_img']) && $_FILES['mentor_img']['error'] === UPLOAD_ERR_OK) {
            $fileName = $_FILES['mentor_img']['name'];
            $tmpPath = $_FILES['mentor_img']['tmp_name'];
            $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $encryptedFileName = hash('sha256', uniqid('', true)) . '.' . $ext;
            $targetPath = $uploadDir . $encryptedFileName;

            // Delete old image
            if (!empty($mentorImgPath)) {
                $oldImage = $uploadDir . $mentorImgPath;
                if (file_exists($oldImage)) unlink($oldImage);
            }

            if (!move_uploaded_file($tmpPath, $targetPath)) {
                throw new Exception("Failed to upload mentor image.");
            }

            $mentorImgPath = $encryptedFileName;
        }

        // Only process CV if a new one is provided
        if (isset($_FILES['mentor_cv']) && $_FILES['mentor_cv']['error'] === UPLOAD_ERR_OK) {
            $cvName = $_FILES['mentor_cv']['name'];
            $cvTmpPath = $_FILES['mentor_cv']['tmp_name'];
            $cvExt = strtolower(pathinfo($cvName, PATHINFO_EXTENSION));
            $encryptedCVName = hash('sha256', uniqid('', true)) . '.' . $cvExt;
            $cvTargetPath = $uploadDir . $encryptedCVName;

            // Delete old CV
            if (!empty($mentorCVPath)) {
                $oldCV = $uploadDir . $mentorCVPath;
                if (file_exists($oldCV)) unlink($oldCV);
            }

            if (!move_uploaded_file($cvTmpPath, $cvTargetPath)) {
                throw new Exception("Failed to upload mentor CV.");
            }

            $mentorCVPath = $encryptedCVName;
        }

        // Update mentor details
        $updateSql = "UPDATE mentor_master SET mentor_name = :mentor_name, phone_no = :phone_no, email_id = :email_id, password = :password,
                      specialization = :specialization, linkedin_profile = :linkedin_profile,
                      is_block = :block_mentor, industry_expert = :industry_expert, photo = :mentor_img, cv = :mentor_cv WHERE mentor_id = :mentor_id";

        $updateStmt = $pdo->prepare($updateSql);
        $updateStmt->execute([
            ':mentor_name' => $mentorName,
            ':phone_no' => $phone_no,
            ':email_id' => $email_id,
            ':password' => $password,
            ':specialization' => $specialization,
            ':linkedin_profile' => $linkedin_profile,
            ':block_mentor' => $block_mentor,
            ':mentor_img' => $mentorImgPath,
            ':mentor_cv' => $mentorCVPath,
            ':mentor_id' => $mentorId,
            ':industry_expert' => $industry_expert
        ]);

        echo json_encode(["status" => "success", "message" => "Mentor updated successfully!"]);
    } catch (Exception $e) {
        echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Mentor name is required."]);
}
?>