<?php

header('Content-Type: application/json');
session_start();
require_once('../includes/connection.php'); // Make sure this is included

// Safely read POST data
$quizIdEncoded = $_POST['quizId'] ?? '';
$quizTitle = trim($_POST['quizTitle'] ?? '');
$rawQuestions = $_POST['selected_questions'] ?? '';

// Validate inputs
if (empty($quizIdEncoded) || empty($quizTitle) || empty($rawQuestions)) {
    echo json_encode([
        "status" => "error",
        "message" => "Quiz ID, title and questions are required."
    ]);
    exit();
}

// Decode and parse
$quizId = base64_decode($quizIdEncoded);
$questionIds = json_decode($rawQuestions, true);

if (!is_array($questionIds) || count($questionIds) === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Please select at least one question."
    ]);
    exit();
}

try {
    $user_id = $_SESSION['user_id'] ?? 0;

    $questionIdsString = implode(',', array_map('intval', $questionIds));

    $updateQuizSql = "UPDATE quiz_master 
                      SET quiz_title = :quiz_title, 
                          question_ids = :question_ids 
                      WHERE quiz_id = :quiz_id AND created_by = :created_by";

    $stmt = $pdo->prepare($updateQuizSql);
    $stmt->bindParam(':quiz_title', $quizTitle);
    $stmt->bindParam(':question_ids', $questionIdsString);
    $stmt->bindParam(':quiz_id', $quizId, PDO::PARAM_INT);
    $stmt->bindParam(':created_by', $user_id, PDO::PARAM_INT);
    $stmt->execute();

    echo json_encode([
        "status" => "success",
        "message" => "Quiz updated successfully!"
    ]);

} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    echo json_encode([
        "status" => "error",
        "message" => "An error occurred while updating the quiz."
    ]);
}