<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (
    isset($data['testimonial_id']) && !empty($data['testimonial_id']) &&
    isset($data['testimonial_name']) && !empty($data['testimonial_name']) &&
    isset($data['learner_since']) && !empty($data['learner_since']) &&
    isset($data['testimonial_text']) && !empty($data['testimonial_text']) &&
    isset($data['is_block'])
) {
    $testimonialId = trim($data['testimonial_id']);
    $testimonialName = trim($data['testimonial_name']);
    $learnerSince = trim($data['learner_since']);
    $testimonialText = trim($data['testimonial_text']);
    $testimonialBlock = trim($data['is_block']);
} else {
    echo json_encode(["status" => "error", "message" => "All fields are required."]);
    exit();
}

try {
    $sql = "UPDATE testimonial_master 
            SET testimonial_name = :testimonial_name, 
                learner_since = :learner_since, 
                testimonial_text = :testimonial_text, 
                is_block = :testimonial_block 
            WHERE testimonial_id = :testimonial_id";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':testimonial_name', $testimonialName);
    $stmt->bindParam(':learner_since', $learnerSince);
    $stmt->bindParam(':testimonial_text', $testimonialText);
    $stmt->bindParam(':testimonial_block', $testimonialBlock);
    $stmt->bindParam(':testimonial_id', $testimonialId);

    $stmt->execute();
    echo json_encode(["status" => "success", "message" => "Testimonial updated successfully!"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
