<?php
header('Content-Type: application/json');
require_once('../includes/connection.php'); // Adjust path

$response = ['success' => false, 'modules' => [], 'message' => ''];

try {
    if (!isset($pdo) || !$pdo instanceof PDO) {
        throw new Exception("PDO connection object not found or invalid.");
    }

    $draftId = filter_input(INPUT_GET, 'draft_id', FILTER_VALIDATE_INT);

    if ($draftId === false || $draftId === null) {
        $response['message'] = 'Invalid Draft ID.';
    } else {
        // Fetch modules that are associated with this draft_id from course_draft_modules table
        // and join with modules table to get module names
        $sql = "SELECT DISTINCT cdm.module_id, m.name AS module_name 
                FROM course_draft_modules cdm
                JOIN modules m ON cdm.module_id = m.id
                WHERE cdm.course_draft_id = :draft_id
                ORDER BY m.name ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':draft_id', $draftId, PDO::PARAM_INT);
        $stmt->execute();
        $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $response['success'] = true;
        $response['modules'] = $modules;
    }

} catch (PDOException $e) {
    $response['message'] = 'Database error: ' . $e->getMessage();
} catch (Exception $e) {
    $response['message'] = 'Application error: ' . $e->getMessage();
}

echo json_encode($response);
?>