<?php
// apis/fetch_proposed_courses.php

require_once('../includes/connection.php'); // Adjust path as necessary
session_start(); // Only if your session logic is needed for this API

header('Content-Type: application/json');

try {
    $category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : null;
    $current_draft_id = isset($_GET['current_draft_id']) ? intval($_GET['current_draft_id']) : null;

    if (!$category_id) {
        echo json_encode(['success' => false, 'message' => 'Category ID is required.']);
        exit();
    }
    // current_draft_id can be null if it's a new course draft, but we'll use it if present.

    $sql = "
        SELECT
            cd.draft_id AS id,
            cd.course_title AS text
        FROM course_draft cd
        WHERE cd.course_category = :category_id
    ";

    // Add condition to exclude current draft if its ID is provided
    if ($current_draft_id !== null) {
        $sql .= " AND cd.draft_id != :current_draft_id";
    }

    $sql .= " ORDER BY cd.course_title ASC";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':category_id', $category_id, PDO::PARAM_INT);

    if ($current_draft_id !== null) {
        $stmt->bindParam(':current_draft_id', $current_draft_id, PDO::PARAM_INT);
    }

    $stmt->execute();
    $proposedCourses = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'courses' => $proposedCourses]);

} catch (PDOException $e) {
    error_log("Database error in fetch_proposed_courses.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error occurred.']);
} catch (Exception $e) {
    error_log("General error in fetch_proposed_courses.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An unexpected error occurred.']);
}
?>