<?php

// Rest of your code
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['module_id'])) {
    echo json_encode(["status" => "error", "message" => "Module ID is required"]);
    exit();
}

$moduleId = $_GET['module_id']; // Correct variable name to match the parameter passed

// Fetch assigned study materials for the given module ID
$query = "SELECT study_material FROM module_master WHERE module_id = :module_id";
$stmt = $pdo->prepare($query);
$stmt->bindParam(':module_id', $moduleId, PDO::PARAM_INT);
$stmt->execute();

$assignedMaterials = $stmt->fetchAll(PDO::FETCH_COLUMN);

echo json_encode($assignedMaterials);
?>
