<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['draft'])) {
    echo json_encode(["status" => "error", "message" => "Course ID is required"]);
    exit();
}

$courseId = ($_GET['draft']);;

try {
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT * FROM course_draft WHERE draft_id = :course_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':course_id', $courseId);
    $stmt->execute();
    $course = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($course) {
        echo json_encode(["status" => "success", "course" => $course]);
    } else {
        echo json_encode(["status" => "error", "message" => "Draft not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
