<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Employee ID is required"]);
    exit();
}

$employeeId = base64_decode($_GET['id']);;

try {
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT 
    e.first_name,
    e.last_name,
    e.phone_no,
    e.email_id,
    e.password,
    e.address,
    e.is_block,
    e.role_id,
    GROUP_CONCAT(r.role_name ORDER BY r.role_name SEPARATOR ', ') AS role_names
FROM 
    employee_master e
LEFT JOIN 
    role_master r ON FIND_IN_SET(r.role_id, e.role_id)
WHERE 
    e.employee_id = :employee_id
GROUP BY 
    e.employee_id;
";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':employee_id', $employeeId);
    $stmt->execute();
    $employee = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($employee) {
        echo json_encode(["status" => "success", "employee" => $employee]);
    } else {
        echo json_encode(["status" => "error", "message" => "Employee not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
