<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Institute ID is required"]);
    exit();
}

$instituteId = base64_decode($_GET['id']);

try {
    // Get institute details
    $sql = "SELECT * 
            FROM institute_master 
            WHERE institute_id = :institute_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':institute_id', $instituteId);
    $stmt->execute();
    $institute = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($institute) {
        // Get contact persons for this institute
        $contactSql = "SELECT contact_name, mobile_no, email_id 
                       FROM institute_contact_person 
                       WHERE institute_id = :institute_id";
        $contactStmt = $pdo->prepare($contactSql);
        $contactStmt->bindParam(':institute_id', $instituteId);
        $contactStmt->execute();
        $contacts = $contactStmt->fetchAll(PDO::FETCH_ASSOC);

        // Get course IDs from institute_courses
        $coursesSql = "SELECT course_id 
                       FROM institute_courses 
                       WHERE institute_id = :institute_id";
        $coursesStmt = $pdo->prepare($coursesSql);
        $coursesStmt->bindParam(':institute_id', $instituteId);
        $coursesStmt->execute();
        $courseIds = $coursesStmt->fetchAll(PDO::FETCH_COLUMN); // returns a flat array

        echo json_encode([
            "status" => "success",
            "institute" => $institute,
            "contacts" => $contacts,
            "courses" => $courseIds
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "Institute not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>