<?php
require_once ('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Module ID is required"]);
    exit();
}

$encodedId = $_GET['id'];
$moduleId = base64_decode($encodedId);

if (!$moduleId) {
    echo json_encode(["status" => "error", "message" => "Invalid module ID"]);
    exit();
}

try {
    $sql = "SELECT module_name, description, is_block FROM module_master WHERE module_id = :module_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':module_id', $moduleId, PDO::PARAM_STR);
    $stmt->execute();
    $module = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($module) {
        echo json_encode(["status" => "success", "module" => $module]);
    } else {
        echo json_encode(["status" => "error", "message" => "Module not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
}
?>