<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Get the institute_id from session
$institute_id = $_SESSION['institute_id'];

try {
    // Prepare and execute the query to fetch all questions for the given institute
    $sql = "SELECT * FROM question_master WHERE is_block != 1 AND institute_id = :institute_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':institute_id', $institute_id); // Correct variable usage
    $stmt->execute();

    // Fetch all matching questions
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($questions) {
        echo json_encode(["status" => "success", "questions" => $questions]);
    } else {
        echo json_encode(["status" => "error", "message" => "No questions found for this institute"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
