<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Testimonial ID is required"]);
    exit();
}

$testimonialId = intval(base64_decode($_GET['id'])); // Decode and validate ID

try {
    $sql = "SELECT testimonial_id, testimonial_name, learner_since, testimonial_text, created_at, is_block 
            FROM testimonial_master 
            WHERE testimonial_id = :testimonial_id";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':testimonial_id', $testimonialId, PDO::PARAM_INT);
    $stmt->execute();
    $testimonials = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($testimonials) {
        echo json_encode(["status" => "success", "testimonials" => $testimonials]);
    } else {
        echo json_encode(["status" => "error", "message" => "No testimonial found."]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>
