<?php
require_once ('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Study Material ID is required"]);
    exit();
}

$institute_id = $_SESSION['institute_id'];
$studyId = base64_decode($_GET['id']);

try {
    // Get current institute folder
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }

    // Fetch mentor details
    $sql = "SELECT category_id, title, description, vimeo_link, actual_file_name, doc_type, original_file_name, is_block 
            FROM study_material 
            WHERE study_material_id = :study_material_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':study_material_id', $studyId);
    $stmt->execute();
    $study_material = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($study_material) {
        $study_material['folder_name'] = $currentFolder; // Add folder_name to mentor array

        echo json_encode([
            "status" => "success",
            "study_material" => $study_material
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "Study Material not found"]);
    }

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>