<?php
require_once ('../includes/connection.php'); // Adjust path as needed

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Submodule ID is required"]);
    exit();
}

$submoduleId = base64_decode($_GET['id']);

try {
    // Check if PDO connection object is available
    if (!isset($pdo) || !$pdo instanceof PDO) {
        throw new Exception("Database connection object (\$pdo) not found or invalid. Ensure 'includes/connection.php' sets up a PDO connection named \$pdo.");
    }

    // SQL query to fetch submodule details AND its associated module_id and module_name
    $sql = "
        SELECT
            sm.submodule_name,
            sm.description,
            sm.module_id,       -- Fetch module_id from submodule_master
            mm.module_name      -- Fetch module_name from module_master
        FROM
            submodule_master sm
        JOIN
            module_master mm ON sm.module_id = mm.module_id
        WHERE
            sm.submodule_id = :submodule_id
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':submodule_id', $submoduleId, PDO::PARAM_INT); // Bind as INT for ID
    $stmt->execute();
    $submodule = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($submodule) {
        echo json_encode(["status" => "success", "submodule" => $submodule]);
    } else {
        echo json_encode(["status" => "error", "message" => "Submodule not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
    // Log the error for debugging
    error_log("PDO Exception in fetch_submodule_details.php: " . $e->getMessage());
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => "Application error: " . $e->getMessage()]);
    error_log("General Exception in fetch_submodule_details.php: " . $e->getMessage());
}
?>