<?php
require_once('../includes/connection.php');
session_start();
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['username']) && isset($data['password'])) {

    $username = trim($data['username']);
    $password = trim($data['password']);
    $remember_me = $data['remember_me'];

    // Validate inputs
    if (empty($username) || empty($password)) {
        echo json_encode(['status' => 'error', 'message' => 'Please fill in both fields.']);
        exit;
    }

    try {
        // Prepare the SQL query to check if the user exists (regardless of block status)
        $sql = "SELECT * FROM user_master WHERE email_id = :username";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->execute();

        // Fetch user data
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            // Check if user is blocked
            if ($user['is_block'] == 1) {
                echo json_encode(['status' => 'error', 'message' => 'Your account has been blocked. Please contact the administrator.']);
                exit;
            }

            // Check password
            if ($password == base64_decode($user['password'])) {
                $_SESSION['email_id'] = $user['email_id'];
                
                if ($remember_me == '1') {
                    setcookie('remembered_username', $username, time() + (86400 * 30), "/");
                    setcookie('remembered_password', $password, time() + (86400 * 30), "/");
                } else {
                    setcookie('remembered_username', '', time() - 3600, "/");
                    setcookie('remembered_password', '', time() - 3600, "/");
                }
                
                echo json_encode(['status' => 'success', 'message' => 'Verify OTP']);
            } else {
                // Invalid password
                echo json_encode(['status' => 'error', 'message' => 'Invalid username or password.']);
            }
        } else {
            // User not found
            echo json_encode(['status' => 'error', 'message' => 'Invalid username or password.']);
        }
    } catch (PDOException $e) {
        // Database error
        echo json_encode(['status' => 'error', 'message' => 'An error occurred. Please try again later.']);
    }
} else {
    // Missing parameters
    echo json_encode(['status' => 'error', 'message' => 'Missing username or password.']);
}
?>