<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'module_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');
    $module_id = $_POST['module_id'] ?? '';

    // Validate sort direction
    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    // Allowed sort fields
    $allowedSortFields = ['module_id', 'is_block', 'module_name'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'module_id';
    }

    // Base WHERE clause
    $searchQuery = "WHERE is_deleted != 1";
    $searchParams = [];

    // Filter by category ID
    if (!empty($module_id)) {
        $searchQuery .= " AND module_id = ?";
        $searchParams[] = $module_id;
    }

    // Search by keyword
    if (!empty($searchValue)) {
        $like = "%$searchValue%";
        $searchQuery .= " AND (module_name LIKE ?";
        $searchParams[] = $like;

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    // Total unfiltered records
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM module_master WHERE is_deleted != 1")->fetchColumn();

    // Total filtered records
    $countSql = "SELECT COUNT(*) FROM module_master $searchQuery";
    $countStmt = $pdo->prepare($countSql);
    $countStmt->execute($searchParams);
    $filteredRecords = $countStmt->fetchColumn();

    // Fetch filtered, paginated records
    $dataSql = "
        SELECT module_id, module_name, is_block
        FROM module_master
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $finalParams = array_merge($searchParams, [$start, $length]);
    $dataStmt->execute($finalParams);
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}